/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.list.events;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MediaListPlayerEventType {
    NEXT_ITEM_SET(1),
    ALL(-1);

    private int value;

    private MediaListPlayerEventType(int value) {
        this.value = value;
    }

    public final int value() {
        return this.value;
    }

    public static int events(MediaListPlayerEventType ... types) {
        int eventMask = 0;
        for (MediaListPlayerEventType type : types) {
            eventMask |= type.value();
        }
        return eventMask;
    }

    public static int notEvents(MediaListPlayerEventType ... types) {
        int eventMask = MediaListPlayerEventType.ALL.value;
        for (MediaListPlayerEventType type : types) {
            eventMask &= ~type.value();
        }
        return eventMask;
    }

    public static boolean set(int value, MediaListPlayerEventType type) {
        return (value & type.value()) != 0;
    }

    public static boolean notSet(int value, MediaListPlayerEventType type) {
        return (value & type.value()) == 0;
    }
}

