/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.MediaPlayer;

public class VideoOutputLatch {
    private final MediaPlayer mediaPlayer;
    private final int period;
    private final long timeout;

    public VideoOutputLatch(MediaPlayer mediaPlayer, int period, int timeout) {
        this.mediaPlayer = mediaPlayer;
        this.period = period;
        this.timeout = timeout;
    }

    public boolean waitForVideoOutput() {
        Logger.debug("waitForVideoOutput()", new Object[0]);
        long start = System.currentTimeMillis();
        while (true) {
            Logger.trace("Checking for video output...", new Object[0]);
            if (this.mediaPlayer.getVideoOutputs() > 0) {
                Logger.debug("Got video output.", new Object[0]);
                return true;
            }
            if (System.currentTimeMillis() - start >= this.timeout) {
                Logger.warn("Timed out waiting for video output.", new Object[0]);
                return false;
            }
            try {
                Logger.trace("Sleeping...", new Object[0]);
                Thread.sleep(this.period);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

