/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.awt.GraphicsEnvironment;
import java.awt.Window;
import org.apache.log4j.Logger;
import uk.co.caprica.vlcj.player.FullScreenStrategy;

public class DefaultFullScreenStrategy
implements FullScreenStrategy {
    private static final Logger LOG = Logger.getLogger(DefaultFullScreenStrategy.class);
    private final Window window;

    public DefaultFullScreenStrategy(Window window) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DefaultFullScreenStrategy(window=" + window + ")"));
        }
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.window = window;
    }

    public void enterFullScreenMode() {
        LOG.debug((Object)"enterFullScreenMode()");
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.window);
    }

    public void exitFullScreenMode() {
        LOG.debug((Object)"exitFullScreenMode()");
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(null);
    }

    public boolean isFullScreenMode() {
        LOG.debug((Object)"isFullScreenMode()");
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getFullScreenWindow() != null;
    }
}

