/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompDecoder;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.util.Assert;

public final class StompEncoder {
    private static final byte LF = 10;
    private static final byte COLON = 58;
    private final Log logger = LogFactory.getLog(StompEncoder.class);

    public byte[] encode(Message<byte[]> message) {
        return this.encode(message.getHeaders(), message.getPayload());
    }

    public byte[] encode(Map<String, Object> headers, byte[] payload) {
        Assert.notNull(headers, (String)"'headers' is required");
        Assert.notNull((Object)payload, (String)"'payload' is required");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128 + payload.length);
            DataOutputStream output = new DataOutputStream(baos);
            if (SimpMessageType.HEARTBEAT.equals((Object)SimpMessageHeaderAccessor.getMessageType(headers))) {
                output.write(StompDecoder.HEARTBEAT_PAYLOAD);
            } else {
                StompCommand command = StompHeaderAccessor.getCommand(headers);
                Assert.notNull((Object)((Object)command), (String)("Missing STOMP command: " + headers));
                output.write(command.toString().getBytes(StompDecoder.UTF8_CHARSET));
                output.write(10);
                this.writeHeaders(command, headers, payload, output);
                output.write(10);
                this.writeBody(payload, output);
                output.write(0);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new StompConversionException("Failed to encode STOMP frame, headers=" + headers + ".", e);
        }
    }

    private void writeHeaders(StompCommand command, Map<String, Object> headers, byte[] payload, DataOutputStream output) throws IOException {
        Map nativeHeaders = (Map)headers.get("nativeHeaders");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Encoding STOMP " + (Object)((Object)command) + ", headers=" + nativeHeaders + "."));
        }
        if (nativeHeaders == null) {
            return;
        }
        boolean shouldEscape = command != StompCommand.CONNECT && command != StompCommand.CONNECTED;
        for (Map.Entry entry : nativeHeaders.entrySet()) {
            byte[] key = this.encodeHeaderString((String)entry.getKey(), shouldEscape);
            if (command.requiresContentLength() && "content-length".equals(entry.getKey())) continue;
            List<String> values = (List<String>)entry.getValue();
            if (StompCommand.CONNECT.equals((Object)command) && "passcode".equals(entry.getKey())) {
                values = Arrays.asList(StompHeaderAccessor.getPasscode(headers));
            }
            for (String value : values) {
                output.write(key);
                output.write(58);
                output.write(this.encodeHeaderString(value, shouldEscape));
                output.write(10);
            }
        }
        if (command.requiresContentLength()) {
            int contentLength = payload.length;
            output.write("content-length:".getBytes(StompDecoder.UTF8_CHARSET));
            output.write(Integer.toString(contentLength).getBytes(StompDecoder.UTF8_CHARSET));
            output.write(10);
        }
    }

    private byte[] encodeHeaderString(String input, boolean escape) {
        input = escape ? this.escape(input) : input;
        return input.getBytes(StompDecoder.UTF8_CHARSET);
    }

    private String escape(String inString) {
        StringBuilder sb = new StringBuilder(inString.length());
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == ':') {
                sb.append("\\c");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void writeBody(byte[] payload, DataOutputStream output) throws IOException {
        output.write(payload);
    }
}

