/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.selectOneLanguage;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.apache.myfaces.custom.selectOneLanguage.SelectOneLanguage;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.ext.HtmlMenuRenderer;

public class SelectOneLanguageRenderer
extends HtmlMenuRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        SelectOneLanguage selectOneLanguage = (SelectOneLanguage)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisplayValueOnly(component)) {
            writer.startElement("span", selectOneLanguage);
            HtmlRendererUtils.writeIdIfNecessary(writer, selectOneLanguage, facesContext);
            String[] supportedAttributes = new String[]{"styleClass", "style"};
            HtmlRendererUtils.renderHTMLAttributes(writer, selectOneLanguage, supportedAttributes);
            String languageCode = selectOneLanguage.getValue().toString();
            String languageName = new Locale(languageCode).getDisplayLanguage(facesContext.getViewRoot().getLocale());
            writer.write(languageName);
            writer.endElement("span");
            return;
        }
        writer.startElement("select", component);
        HtmlRendererUtils.writeIdIfNecessary(writer, selectOneLanguage, facesContext);
        writer.writeAttribute("name", selectOneLanguage.getClientId(facesContext), null);
        List selectItemList = selectOneLanguage.getLanguagesChoicesAsSelectItemList();
        Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, selectOneLanguage);
        writer.writeAttribute("size", "1", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, selectOneLanguage, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, selectOneLanguage)) {
            writer.writeAttribute("disabled", Boolean.TRUE, null);
        }
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(false, selectOneLanguage, facesContext, converter);
        HtmlRendererUtils.renderSelectOptions(facesContext, selectOneLanguage, converter, lookupSet, selectItemList);
        writer.writeText("", null);
        writer.endElement("select");
    }
}

