/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$component$html$util$MultipartRequestWrapper == null ? (class$org$apache$myfaces$component$html$util$MultipartRequestWrapper = MultipartRequestWrapper.class$("org.apache.myfaces.component.html.util.MultipartRequestWrapper")) : class$org$apache$myfaces$component$html$util$MultipartRequestWrapper));
    HttpServletRequest request = null;
    HashMap parametersMap = null;
    DiskFileUpload fileUpload = null;
    HashMap fileItems = null;
    int maxSize;
    int thresholdSize;
    String repositoryPath;
    static /* synthetic */ Class class$org$apache$myfaces$component$html$util$MultipartRequestWrapper;

    public MultipartRequestWrapper(HttpServletRequest request, int maxSize, int thresholdSize, String repositoryPath) {
        super(request);
        this.request = request;
        this.maxSize = maxSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
    }

    private void parseRequest() {
        this.fileUpload = new DiskFileUpload();
        this.fileUpload.setFileItemFactory((FileItemFactory)new DefaultFileItemFactory());
        this.fileUpload.setSizeMax((long)this.maxSize);
        this.fileUpload.setSizeThreshold(this.thresholdSize);
        if (this.repositoryPath != null && this.repositoryPath.trim().length() > 0) {
            this.fileUpload.setRepositoryPath(this.repositoryPath);
        }
        String charset = this.request.getCharacterEncoding();
        this.fileUpload.setHeaderEncoding(charset);
        List requestParameters = null;
        try {
            requestParameters = this.fileUpload.parseRequest(this.request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            if (log.isInfoEnabled()) {
                log.info((Object)"user tried to upload a file that exceeded file-size limitations.", (Throwable)e);
            }
            requestParameters = Collections.EMPTY_LIST;
        }
        catch (FileUploadException fue) {
            log.error((Object)"Exception while uploading file.", (Throwable)fue);
            requestParameters = Collections.EMPTY_LIST;
        }
        this.parametersMap = new HashMap(requestParameters.size());
        this.fileItems = new HashMap();
        Iterator iter = requestParameters.iterator();
        while (iter.hasNext()) {
            FileItem fileItem = (FileItem)iter.next();
            if (fileItem.isFormField()) {
                String name = fileItem.getFieldName();
                String value = null;
                if (charset == null) {
                    value = fileItem.getString();
                } else {
                    try {
                        value = new String(fileItem.get(), charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        value = fileItem.getString();
                    }
                }
                this.addTextParameter(name, value);
                continue;
            }
            if (fileItem.getName() == null) continue;
            this.fileItems.put(fileItem.getFieldName(), fileItem);
        }
        Iterator it = this.request.getParameterMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String[] valuesArray = (String[])entry.getValue();
            for (int i = 0; i < valuesArray.length; ++i) {
                this.addTextParameter((String)entry.getKey(), valuesArray[i]);
            }
        }
    }

    private void addTextParameter(String name, String value) {
        if (!this.parametersMap.containsKey(name)) {
            String[] valuesArray = new String[]{value};
            this.parametersMap.put(name, valuesArray);
        } else {
            String[] storedValues = (String[])this.parametersMap.get(name);
            int lengthSrc = storedValues.length;
            String[] valuesArray = new String[lengthSrc + 1];
            System.arraycopy(storedValues, 0, valuesArray, 0, lengthSrc);
            valuesArray[lengthSrc] = value;
            this.parametersMap.put(name, valuesArray);
        }
    }

    public Enumeration getParameterNames() {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return Collections.enumeration(this.parametersMap.keySet());
    }

    public String getParameter(String name) {
        String[] values;
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        if ((values = (String[])this.parametersMap.get(name)) == null) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return (String[])this.parametersMap.get(name);
    }

    public Map getParameterMap() {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return this.parametersMap;
    }

    public FileItem getFileItem(String fieldName) {
        if (this.fileItems == null) {
            this.parseRequest();
        }
        return (FileItem)this.fileItems.get(fieldName);
    }

    public Map getFileItems() {
        return this.fileItems;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

