/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.myfaces.component.html.ext._SerializableDataModel;

public abstract class HtmlDataTableHack
extends HtmlDataTable {
    private Map _dataModelMap = new HashMap();
    private boolean _isValidChilds = true;
    private Map _rowStates = new HashMap();
    private Object _initialDescendantComponentState = null;
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private int _rowIndex = -1;
    private static final DataModel EMPTY_DATA_MODEL = new _SerializableDataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IndexOutOfBoundsException("Index < 0 : " + i);
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    };

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    public void processValidators(FacesContext context) {
        super.processValidators(context);
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this._isValidChilds) {
            this._dataModelMap.clear();
            this._rowStates.clear();
            this._initialDescendantComponentState = null;
        }
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.setRowIndex(-1);
        super.encodeEnd(context);
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        if (this._rowIndex == rowIndex) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this._rowIndex == -1) {
            if (this._initialDescendantComponentState == null) {
                this._initialDescendantComponentState = this.saveDescendantComponentStates(this.getChildren().iterator(), false);
            }
        } else {
            this._rowStates.put(this.getClientId(facesContext), this.saveDescendantComponentStates(this.getChildren().iterator(), false));
        }
        this._rowIndex = rowIndex;
        DataModel dataModel = this.getDataModel();
        dataModel.setRowIndex(rowIndex);
        String var = this.getVar();
        if (rowIndex == -1) {
            if (var != null) {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        } else if (var != null) {
            if (this.isRowAvailable()) {
                Object rowData = dataModel.getRowData();
                facesContext.getExternalContext().getRequestMap().put(var, rowData);
            } else {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        }
        if (this._rowIndex == -1) {
            this.restoreDescendantComponentStates(this.getChildren().iterator(), this._initialDescendantComponentState, false);
        } else {
            Object rowState = this._rowStates.get(this.getClientId(facesContext));
            if (rowState == null) {
                this.restoreDescendantComponentStates(this.getChildren().iterator(), this._initialDescendantComponentState, false);
            } else {
                this.restoreDescendantComponentStates(this.getChildren().iterator(), rowState, false);
            }
        }
    }

    private void restoreDescendantComponentStates(Iterator childIterator, Object state, boolean restoreChildFacets) {
        Iterator descendantStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = ((Collection)state).iterator();
            }
            UIComponent component = (UIComponent)childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childState = null;
            Object descendantState = null;
            if (descendantStateIterator != null && descendantStateIterator.hasNext()) {
                Object[] object = (Object[])descendantStateIterator.next();
                childState = object[0];
                descendantState = object[1];
            }
            if (component instanceof EditableValueHolder) {
                ((EditableValueHolderState)childState).restoreState((EditableValueHolder)((Object)component));
            }
            Iterator childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreDescendantComponentStates(childsIterator, descendantState, true);
        }
    }

    private Object saveDescendantComponentStates(Iterator childIterator, boolean saveChildFacets) {
        ArrayList<Object[]> childStates = null;
        while (childIterator.hasNext()) {
            UIComponent child;
            if (childStates == null) {
                childStates = new ArrayList<Object[]>();
            }
            if ((child = (UIComponent)childIterator.next()).isTransient()) continue;
            Iterator childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            Object descendantState = this.saveDescendantComponentStates(childsIterator, true);
            EditableValueHolderState state = null;
            if (child instanceof EditableValueHolder) {
                state = new EditableValueHolderState((EditableValueHolder)((Object)child));
            }
            childStates.add(new Object[]{state, descendantState});
        }
        return childStates;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this._dataModelMap.clear();
        } else if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("name " + name);
        }
        super.setValueBinding(name, binding);
    }

    public void setValue(Object value) {
        super.setValue(value);
        this._dataModelMap.clear();
        this._rowStates.clear();
        this._isValidChilds = true;
    }

    protected DataModel getDataModel() {
        String clientID = this.getParent().getClientId(this.getFacesContext());
        DataModel dataModel = (DataModel)this._dataModelMap.get(clientID);
        if (dataModel == null) {
            dataModel = this.createDataModel();
            this._dataModelMap.put(clientID, dataModel);
        }
        return dataModel;
    }

    protected void setDataModel(DataModel datamodel) {
        this._dataModelMap.put(this.getParent().getClientId(this.getFacesContext()), datamodel);
    }

    protected DataModel createDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return EMPTY_DATA_MODEL;
        }
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        if (value instanceof Collection) {
            return new ListDataModel(new ArrayList((Collection)value));
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new ArrayDataModel((Object[])value);
        }
        if (value instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)value);
        }
        if (value instanceof Result) {
            return new ResultDataModel((Result)value);
        }
        return new ScalarDataModel(value);
    }

    private class EditableValueHolderState {
        private final Object _value;
        private final boolean _localValueSet;
        private final boolean _valid;
        private final Object _submittedValue;

        public EditableValueHolderState(EditableValueHolder evh) {
            this._value = evh.getLocalValue();
            this._localValueSet = evh.isLocalValueSet();
            this._valid = evh.isValid();
            this._submittedValue = evh.getSubmittedValue();
        }

        public void restoreState(EditableValueHolder evh) {
            evh.setValue(this._value);
            evh.setLocalValueSet(this._localValueSet);
            evh.setValid(this._valid);
            evh.setSubmittedValue(this._submittedValue);
        }
    }
}

