/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.xml;

import java.io.Console;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class XPathRunner {
    private static String fileName;
    private static String expr;
    private static Document document;

    public static void main(String[] args) throws Exception {
        switch (args.length) {
            case 0: {
                System.err.println("Usage: XPathRunner file [xpath-expr]\n");
                return;
            }
            case 2: {
                expr = args[1];
            }
            case 1: {
                fileName = args[0];
            }
        }
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = parser.parse(new FileInputStream(fileName));
        boolean done = false;
        if (expr == null) {
            do {
                expr = XPathRunner.promptForPathExpr();
                System.out.println(XPathRunner.eval(expr));
            } while (!done);
        } else {
            System.out.println(XPathRunner.eval(expr));
        }
    }

    private static String eval(String expr) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String secNum = (String)xpath.evaluate(expr, document, XPathConstants.STRING);
        return secNum;
    }

    private static String promptForPathExpr() {
        Console c = System.console();
        if (c == null) {
            throw new IllegalStateException("This app needs a 'controlling terminal' to prompt; use with filename and expr arguments");
        }
        return c.readLine("Enter XPath prompt for %s", fileName);
    }
}

