/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.tel;

import java.util.Locale;

public class DialWords {
    public static final char[][] KB = new char[][]{{'0', '0', '0'}, {'1', '1', '1'}, {'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}, {'j', 'k', 'l'}, {'m', 'n', 'o'}, {'p', 'r', 's'}, {'t', 'u', 'v'}, {'w', 'x', 'y', 'z'}};
    public static final int[] REV = new int[]{2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, -1, 7, 7, 8, 8, 8, 9, 9, 9, 9};

    public static String nameToNumber(String name) {
        StringBuilder s = new StringBuilder();
        for (char c : name.toLowerCase(Locale.ENGLISH).toCharArray()) {
            int i;
            int index;
            if (!Character.isLetter(c) || (index = c - 97) < 0 || index > REV.length || (i = REV[index]) <= 0) continue;
            s.append((char)(i + 48));
        }
        return s.toString();
    }

    public static String[] numberToName(String number) {
        if (number.length() != 4) {
            throw new IllegalArgumentException("This version can only handle 4-digit numbers");
        }
        for (int i = 0; i < number.length(); ++i) {
            if (number.charAt(i) >= '0' && number.charAt(i) <= '9') continue;
            throw new IllegalArgumentException(number);
        }
        char[] chars = number.toCharArray();
        int nResults = 81;
        char[][] results = new char[nResults][4];
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    for (int l = 0; l < 3; ++l) {
                        for (int r = 0; r < 3; ++r) {
                            results[index][0] = KB[chars[i] - 48][r];
                            results[index][1] = KB[chars[j] - 48][r];
                            results[index][2] = KB[chars[k] - 48][r];
                            results[index][3] = KB[chars[l] - 48][r];
                        }
                        ++index;
                    }
                }
            }
        }
        String[] sResults = new String[nResults];
        for (int n = 0; n < nResults; ++n) {
            sResults[n] = new String(results[n]);
        }
        return sResults;
    }
}

