/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui.framework;

import com.darwinsys.swingui.SimpleHelp;
import com.darwinsys.swingui.UtilGUI;
import com.darwinsys.swingui.framework.Model;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class MenuController {
    JFrame parentFrame;
    Model model;
    PrintJob printJob;
    protected JFileChooser chooser;

    public MenuController(JFrame prnt, Model mod) {
        this.parentFrame = prnt;
        this.model = mod;
    }

    public void makeMenus() {
        JMenuBar mb = new JMenuBar();
        this.parentFrame.setJMenuBar(mb);
        ResourceBundle b = ResourceBundle.getBundle("Menu");
        JMenu fm = this.mkMenu(b, "file");
        JMenuItem mi = this.mkMenuItem(b, "file", "open");
        fm.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal;
                String fileName = null;
                if (MenuController.this.model.getFileName() != null) {
                    MenuController.this.model.openFile(null);
                    return;
                }
                if (MenuController.this.chooser == null) {
                    MenuController.this.chooser = new JFileChooser();
                }
                if ((returnVal = MenuController.this.chooser.showOpenDialog(MenuController.this.parentFrame)) == 0) {
                    File file = MenuController.this.chooser.getSelectedFile();
                    fileName = file.getPath();
                }
                MenuController.this.model.openFile(fileName);
                MenuController.this.parentFrame.pack();
            }
        });
        mi = this.mkMenuItem(b, "file", "new");
        fm.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = JOptionPane.showInputDialog(MenuController.this.parentFrame, (Object)"FileName");
                MenuController.this.model.newFile(fileName);
            }
        });
        mi = this.mkMenuItem(b, "file", "save");
        fm.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.model.saveFile(null);
            }
        });
        mi = this.mkMenuItem(b, "file", "close");
        fm.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.model.closeFile();
            }
        });
        fm.addSeparator();
        mi = this.mkMenuItem(b, "file", "print");
        fm.add(mi);
        class PrintListener
        implements ActionListener {
            PrintListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.printJob = Toolkit.getDefaultToolkit().getPrintJob(MenuController.this.parentFrame, "Print CrossWord", null);
                if (MenuController.this.printJob == null) {
                    return;
                }
                Graphics g = MenuController.this.printJob.getGraphics();
                if (g == null) {
                    throw new IllegalArgumentException("pjob.getGraphics() gave me a null!");
                }
                MenuController.this.model.doPrint(g);
                g.dispose();
                MenuController.this.printJob.end();
            }
        }
        mi.addActionListener(new PrintListener());
        fm.addSeparator();
        mi = this.mkMenuItem(b, "file", "exit");
        fm.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.model.exit(0);
            }
        });
        mb.add(fm);
        JMenu em = this.mkMenu(b, "edit");
        mi = this.mkMenuItem(b, "edit", "copy");
        em.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.model.copySelection();
                MenuController.this.parentFrame.repaint();
            }
        });
        mi = this.mkMenuItem(b, "edit", "paste");
        em.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.model.pasteSelection();
            }
        });
        mi = this.mkMenuItem(b, "edit", "clear");
        em.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.model.clearSelection();
            }
        });
        mb.add(em);
        this.addAdditionalMenus(mb);
        JMenu hm = this.mkMenu(b, "help");
        mi = this.mkMenuItem(b, "help", "topics");
        hm.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleHelp jh = new SimpleHelp("CW-Edit", "??");
                UtilGUI.centre(jh);
                jh.setVisible(true);
            }
        });
        hm.addSeparator();
        mi = this.mkMenuItem(b, "help", "about");
        hm.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.showAboutPane();
            }
        });
        mb.add(hm);
    }

    protected void showAboutPane() {
        JOptionPane.showMessageDialog(this.parentFrame, "About your program - you need to override\nthe showAboutPane() method", "Incomplete program!", 0);
    }

    protected void addAdditionalMenus(JMenuBar mb) {
    }

    public JMenu mkMenu(ResourceBundle b, String name) {
        String menuLabel;
        try {
            menuLabel = b.getString(name + ".label");
        }
        catch (MissingResourceException e) {
            menuLabel = name;
        }
        return new JMenu(menuLabel);
    }

    public JMenuItem mkMenuItem(ResourceBundle b, String menu, String name) {
        String miLabel;
        try {
            miLabel = b.getString(menu + "." + name + ".label");
        }
        catch (MissingResourceException e) {
            miLabel = name;
        }
        String key = null;
        try {
            key = b.getString(menu + "." + name + ".key");
        }
        catch (MissingResourceException e) {
            key = null;
        }
        if (key == null) {
            return new JMenuItem(miLabel);
        }
        return new JMenuItem(miLabel);
    }

    public JCheckBoxMenuItem mkCheckboxMenuItem(ResourceBundle b, String menu, String name) {
        String miLabel;
        try {
            miLabel = b.getString(menu + "." + name + ".label");
        }
        catch (MissingResourceException e) {
            miLabel = name;
        }
        return new JCheckBoxMenuItem(miLabel);
    }
}

