/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.sql.ResultsDecorator;
import com.darwinsys.util.Verbosity;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.WebRowSet;

public class ResultsDecoratorXML
extends ResultsDecorator {
    private static final String SUN_WEBROWSET_IMPL_CLASS = "com.sun.rowset.WebRowSetImpl";
    WebRowSet results;

    public ResultsDecoratorXML(PrintWriter out, Verbosity v) {
        super(out, v);
        try {
            Class<?> c = Class.forName(SUN_WEBROWSET_IMPL_CLASS);
            this.results = (WebRowSet)c.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("can't load com.sun.rowset.WebRowSetImpl, check CLASSPATH");
        }
    }

    @Override
    public int write(ResultSet rs) throws SQLException {
        this.results.writeXml(rs, this.out);
        return this.results.getRow();
    }

    @Override
    public void displayTable(String table, ResultSet rs) throws IOException, SQLException {
        this.write(rs);
    }

    @Override
    public void printRowCount(int rowCount) throws IOException {
        System.err.println("RowCount: " + rowCount);
    }

    @Override
    public String getName() {
        return "XML";
    }
}

