/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.database.DataBaseException;
import com.darwinsys.sql.Configuration;
import com.darwinsys.sql.SimpleSQLConfiguration;
import com.darwinsys.util.Verbosity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class ConnectionUtil {
    public static final String DEFAULT_NAME = ".db.properties";
    private static String configFileName = System.getProperty("user.home") + File.separator + ".db.properties";
    private static Verbosity verbosity = Verbosity.QUIET;

    public static void setConfigFileName(String configFileName) {
        File file = new File(configFileName);
        if (!file.canRead()) {
            throw new IllegalArgumentException("Unreadable: " + configFileName);
        }
        try {
            ConnectionUtil.configFileName = file.getCanonicalPath();
        }
        catch (IOException ex) {
            System.err.println("Warning: IO error checking path: " + configFileName);
            ConnectionUtil.configFileName = configFileName;
        }
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public static Configuration getConfiguration(String config) throws DataBaseException {
        InputStream inputStream = null;
        try {
            Properties p = new Properties();
            inputStream = ConnectionUtil.class.getResourceAsStream("/.db.properties");
            if (inputStream == null) {
                inputStream = new FileInputStream(configFileName);
            }
            p.load(new FileInputStream(configFileName));
            SimpleSQLConfiguration simpleSQLConfiguration = ConnectionUtil.getConfiguration(p, config);
            return simpleSQLConfiguration;
        }
        catch (IOException ex) {
            throw new DataBaseException(ex.toString());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException stupidException) {}
            }
        }
    }

    static SimpleSQLConfiguration getConfiguration(Properties p, String config) {
        String db_url = p.getProperty(config + "." + "DBURL");
        String db_driver = p.getProperty(config + "." + "DBDriver");
        String db_user = p.getProperty(config + "." + "DBUser");
        String db_password = p.getProperty(config + "." + "DBPassword");
        if (db_driver == null || db_url == null) {
            throw new DataBaseException("Driver or URL null: " + config);
        }
        return new SimpleSQLConfiguration(config, db_url, db_driver, db_user, db_password);
    }

    public static Connection getConnection(String configName) throws DataBaseException {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(configFileName));
            return ConnectionUtil.getConnection(p, configName);
        }
        catch (IOException ex) {
            throw new DataBaseException(ex.toString());
        }
    }

    public static Connection getConnection(Properties p, String configName) throws DataBaseException {
        try {
            String db_url = p.getProperty(configName + "." + "DBURL");
            String db_driver = p.getProperty(configName + "." + "DBDriver");
            String db_user = p.getProperty(configName + "." + "DBUser");
            String db_password = p.getProperty(configName + "." + "DBPassword");
            if (db_driver == null || db_url == null) {
                throw new DataBaseException("Driver or URL null: " + configName);
            }
            return ConnectionUtil.getConnection(db_url, db_driver, db_user, db_password);
        }
        catch (ClassNotFoundException ex) {
            throw new DataBaseException(ex.toString());
        }
        catch (SQLException ex) {
            throw new DataBaseException(ex.toString());
        }
    }

    public static Connection getConnection(String dbUrl, String dbDriver, String dbUserName, String dbPassword) throws ClassNotFoundException, SQLException {
        if (verbosity != Verbosity.QUIET) {
            System.out.println("Loading driver " + dbDriver);
        }
        Class.forName(dbDriver);
        if (verbosity != Verbosity.QUIET) {
            System.out.println("Connecting to DB " + dbUrl);
        }
        return DriverManager.getConnection(dbUrl, dbUserName, dbPassword);
    }

    public static Connection getConnection(Configuration c) throws ClassNotFoundException, SQLException {
        return ConnectionUtil.getConnection(c.getDbURL(), c.getDriverName(), c.getUserName(), c.getPassword());
    }

    public static Set<String> getConfigurationNames() {
        TreeSet<String> configNames = new TreeSet<String>();
        try {
            Properties p = new Properties();
            FileInputStream is = new FileInputStream(configFileName);
            p.load(is);
            is.close();
            Enumeration<Object> enumeration = p.keys();
            while (enumeration.hasMoreElements()) {
                String element = (String)enumeration.nextElement();
                int offset = element.indexOf(46);
                if (offset == -1) continue;
                String configName = element.substring(0, offset);
                configNames.add(configName);
            }
        }
        catch (IOException ex) {
            throw new DataBaseException(ex.toString());
        }
        return configNames;
    }

    public static List<Configuration> getConfigurations() {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        for (String name : ConnectionUtil.getConfigurationNames()) {
            configs.add(ConnectionUtil.getConfiguration(name));
        }
        return configs;
    }

    public static String transactionIsolationToString(int txisolation) {
        switch (txisolation) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        throw new IllegalArgumentException(txisolation + " not a valid TX_ISOLATION");
    }

    public static Verbosity getVerbosity() {
        return verbosity;
    }

    public static void setVerbosity(Verbosity verbosity) {
        ConnectionUtil.verbosity = verbosity;
    }
}

