/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.csv;

import com.darwinsys.csv.CSVParser;
import com.darwinsys.util.Debug;
import java.util.ArrayList;
import java.util.List;

public class CSVImport
implements CSVParser {
    public static final char DEFAULT_SEP = ',';
    protected List<String> list = new ArrayList<String>();
    protected char fieldSep;

    public CSVImport() {
        this(',');
    }

    public CSVImport(char sep) {
        this.fieldSep = sep;
    }

    @Override
    public List<String> parse(String line) {
        StringBuffer sb = new StringBuffer();
        this.list.clear();
        int i = 0;
        if (line.length() == 0) {
            this.list.add(line);
            return this.list;
        }
        do {
            sb.setLength(0);
            if (i < line.length() && line.charAt(i) == '\"') {
                ++i;
                i = this.advQuoted(line, sb, i);
            } else {
                i = this.advPlain(line, sb, i);
            }
            this.list.add(sb.toString());
            Debug.println("csv", sb.toString());
        } while (++i < line.length());
        return this.list;
    }

    protected int advQuoted(String s, StringBuffer sb, int i) {
        int j;
        int len = s.length();
        for (j = i; j < len; ++j) {
            if (s.charAt(j) == '\"' && j + 1 < len) {
                if (s.charAt(j + 1) == '\"') {
                    ++j;
                } else if (s.charAt(j + 1) == this.fieldSep) {
                    ++j;
                    break;
                }
            } else if (s.charAt(j) == '\"' && j + 1 == len) break;
            sb.append(s.charAt(j));
        }
        return j;
    }

    protected int advPlain(String s, StringBuffer sb, int i) {
        int j = s.indexOf(this.fieldSep, i);
        Debug.println("csv", "i = " + i + ", j = " + j);
        if (j == -1) {
            sb.append(s.substring(i));
            return s.length();
        }
        sb.append(s.substring(i, j));
        return j;
    }
}

