/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.calendar;

import com.darwinsys.calendar.CalendarEvent;
import com.darwinsys.calendar.Person;
import java.io.PrintWriter;
import java.util.Calendar;

public class ICalendarUtil {
    private ICalendarUtil() {
    }

    public static void writeEvent(PrintWriter pw, CalendarEvent a) {
        pw.println("BEGIN:VCALENDAR");
        pw.println("CALSCALE:GREGORIAN");
        pw.println("VERSION:2.0");
        pw.println("METHOD:PUBLISH");
        pw.println("BEGIN:VEVENT");
        pw.printf("UID: %s%n", a.getUuid());
        Calendar c = Calendar.getInstance();
        pw.printf("LAST-MODIFIED:%s%n", ICalendarUtil.dateString(c));
        pw.printf("DTSTAMP:%s%n", ICalendarUtil.dateString(c));
        pw.printf("DTSTART:%s%n", ICalendarUtil.dateString(a.getYear(), a.getMonth(), a.getDay(), a.getStartHour(), a.getStartMinute()));
        pw.printf("DTEND:%s%n", ICalendarUtil.dateString(a.getYear(), a.getMonth(), a.getDay(), a.getEndHour(), a.getEndMinute()));
        pw.println("TRANSP:OPAQUE");
        pw.printf("X-MICROSOFT-CDO-BUSYSTATUS: %s%n", new Object[]{a.getShowStatus()});
        pw.println("SEQUENCE:0");
        pw.println("DESCRIPTION: " + a.getDescription());
        pw.println("SUMMARY: " + a.getSummary());
        pw.println("LOCATION: " + a.getLocation());
        pw.println("CLASS:PUBLIC");
        if (a.getOrganizer() != null) {
            Person o = a.getOrganizer();
            pw.printf("ORGANIZER;ROLE=REQ-PARTICIPANT;CUTYPE=INDIVIDUAL;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=%s:MAILTO:%s%n", o.getFullName(), o.getEmail());
        }
        if (a.getAttendees() != null) {
            for (Person attendee : a.getAttendees()) {
                pw.printf("ATTENDEE;ROLE=REQ-PARTICIPANT;CUTYPE=INDIVIDUAL;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=%s:MAILTO:%s%n", attendee.getFullName(), attendee.getEmail());
            }
        }
        pw.println("END:VEVENT");
        pw.println("END:VCALENDAR");
    }

    public static String dateString(int year, int month, int day, int hour, int minute) {
        return String.format("%04d%02d%02dT%02d%02d00", year, month, day, hour, minute);
    }

    public static String dateString(Calendar d) {
        return ICalendarUtil.dateString(d.get(1), d.get(2) + 1, d.get(5), d.get(11), d.get(12));
    }
}

