/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlCaller;
import org.perl.inline.java.InlineJavaProtocol;
import org.perl.inline.java.InlineJavaServerThread;
import org.perl.inline.java.InlineJavaUserClassLoader;
import org.perl.inline.java.InlineJavaUtils;

public class InlineJavaServer {
    private static InlineJavaServer instance = null;
    private int port = 0;
    private boolean shared_jvm = false;
    private boolean priv = false;
    private InlineJavaUserClassLoader ijucl = null;
    private HashMap thread_objects = new HashMap();
    private int objid = 1;
    private boolean jni = false;
    private Thread creator = null;
    private int thread_count = 0;

    public InlineJavaServer(int n) {
        this.init(n);
        this.jni = true;
        this.AddThread(this.creator);
    }

    public InlineJavaServer(String[] stringArray) {
        this.init(new Integer(stringArray[0]));
        this.jni = false;
        this.port = Integer.parseInt(stringArray[1]);
        this.shared_jvm = new Boolean(stringArray[2]);
        this.priv = new Boolean(stringArray[3]);
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
        }
        catch (IOException iOException) {
            InlineJavaUtils.Fatal("Can't open server socket on port " + String.valueOf(this.port) + ": " + iOException.getMessage());
        }
        while (true) {
            try {
                InlineJavaServerThread inlineJavaServerThread;
                do {
                    String string = "IJST-#" + this.thread_count++;
                    inlineJavaServerThread = new InlineJavaServerThread(string, this, serverSocket.accept(), this.priv ? new InlineJavaUserClassLoader() : this.ijucl);
                    inlineJavaServerThread.start();
                } while (this.shared_jvm);
                try {
                    inlineJavaServerThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                System.err.println("IO error: " + iOException.getMessage());
                System.err.flush();
                continue;
            }
            break;
        }
        System.exit(1);
    }

    private void init(int n) {
        instance = this;
        this.creator = Thread.currentThread();
        InlineJavaUtils.debug = n;
        this.ijucl = new InlineJavaUserClassLoader();
    }

    static InlineJavaServer GetInstance() {
        if (instance == null) {
            InlineJavaUtils.Fatal("No instance of InlineJavaServer has been created!");
        }
        return instance;
    }

    InlineJavaUserClassLoader GetUserClassLoader() {
        Thread thread = Thread.currentThread();
        if (thread instanceof InlineJavaServerThread) {
            return ((InlineJavaServerThread)thread).GetUserClassLoader();
        }
        return this.ijucl;
    }

    String GetType() {
        return this.shared_jvm ? "shared" : "private";
    }

    boolean IsJNI() {
        return this.jni;
    }

    String ProcessCommand(String string) {
        return this.ProcessCommand(string, true);
    }

    String ProcessCommand(String string, boolean bl) {
        InlineJavaUtils.debug(3, "packet recv is " + string);
        String string2 = null;
        if (string != null) {
            InlineJavaProtocol inlineJavaProtocol = new InlineJavaProtocol(this, string);
            try {
                inlineJavaProtocol.Do();
                InlineJavaUtils.debug(3, "packet sent is " + inlineJavaProtocol.GetResponse());
                string2 = inlineJavaProtocol.GetResponse();
            }
            catch (InlineJavaException inlineJavaException) {
                String string3 = "error scalar:" + inlineJavaProtocol.Encode(inlineJavaException.getMessage());
                InlineJavaUtils.debug(3, "packet sent is " + string3);
                string2 = string3;
            }
        } else if (!this.shared_jvm) {
            InlineJavaUtils.debug(1, "lost connection with client in single client mode. Exiting.");
            System.exit(1);
        } else {
            InlineJavaUtils.debug(1, "lost connection with client in shared JVM mode.");
            return null;
        }
        if (bl) {
            string2 = string2 + "\n";
        }
        return string2;
    }

    native String jni_callback(String var1);

    boolean IsThreadPerlContact(Thread thread) {
        return this.jni && thread == this.creator || !this.jni && thread instanceof InlineJavaServerThread;
    }

    synchronized Object GetObject(int n) throws InlineJavaException {
        Object var2_2 = null;
        HashMap hashMap = (HashMap)this.thread_objects.get(Thread.currentThread());
        if (hashMap == null) {
            throw new InlineJavaException("Can't find thread " + Thread.currentThread().getName() + "!");
        }
        var2_2 = hashMap.get(new Integer(n));
        if (var2_2 == null) {
            throw new InlineJavaException("Can't find object " + n + " for thread " + Thread.currentThread().getName());
        }
        return var2_2;
    }

    synchronized int PutObject(Object object) throws InlineJavaException {
        HashMap hashMap = (HashMap)this.thread_objects.get(Thread.currentThread());
        int n = this.objid;
        if (hashMap == null) {
            throw new InlineJavaException("Can't find thread " + Thread.currentThread().getName() + "!");
        }
        hashMap.put(new Integer(this.objid), object);
        ++this.objid;
        return n;
    }

    synchronized Object DeleteObject(int n) throws InlineJavaException {
        Object var2_2 = null;
        HashMap hashMap = (HashMap)this.thread_objects.get(Thread.currentThread());
        if (hashMap == null) {
            throw new InlineJavaException("Can't find thread " + Thread.currentThread().getName() + "!");
        }
        var2_2 = hashMap.remove(new Integer(n));
        if (var2_2 == null) {
            throw new InlineJavaException("Can't find object " + n + " for thread " + Thread.currentThread().getName());
        }
        return var2_2;
    }

    synchronized int ObjectCount() throws InlineJavaException {
        int n = -1;
        HashMap hashMap = (HashMap)this.thread_objects.get(Thread.currentThread());
        if (hashMap == null) {
            throw new InlineJavaException("Can't find thread " + Thread.currentThread().getName() + "!");
        }
        n = hashMap.values().size();
        return n;
    }

    synchronized void AddThread(Thread thread) {
        this.thread_objects.put(thread, new HashMap());
        InlineJavaPerlCaller.AddThread(thread);
    }

    synchronized void RemoveThread(InlineJavaServerThread inlineJavaServerThread) {
        this.thread_objects.remove(inlineJavaServerThread);
        InlineJavaPerlCaller.RemoveThread(inlineJavaServerThread);
    }

    public static void main(String[] stringArray) {
        new InlineJavaServer(stringArray);
    }

    public static InlineJavaServer jni_main(int n) {
        return new InlineJavaServer(n);
    }
}

