/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.events;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MediaPlayerEventType {
    MEDIA_CHANGED(1),
    OPENING(2),
    BUFFERING(4),
    PLAYING(8),
    PAUSED(16),
    STOPPED(32),
    FORWARD(64),
    BACKWARD(128),
    FINISHED(256),
    TIME_CHANGED(512),
    POSITION_CHANGED(1024),
    SEEKABLE_CHANGED(2048),
    PAUSABLE_CHANGED(4096),
    TITLE_CHANGED(8192),
    SNAPSHOT_TAKEN(16384),
    LENGTH_CHANGED(32768),
    ERROR(65536),
    MEDIA_META_CHANGED(131072),
    MEDIA_SUB_ITEM_ADDED(262144),
    MEDIA_DURATION_CHANGED(524288),
    MEDIA_PARSED_CHANGED(0x100000),
    MEDIA_FREED(0x200000),
    MEDIA_STATE_CHANGED(0x400000),
    NEW_MEDIA(0x800000),
    SUB_ITEM_PLAYED(0x1000000),
    SUB_ITEM_FINISHED(0x2000000),
    END_OF_SUB_ITEMS(0x4000000),
    ALL(-1);

    private int value;

    private MediaPlayerEventType(int value) {
        this.value = value;
    }

    public final int value() {
        return this.value;
    }

    public static int events(MediaPlayerEventType ... types) {
        int eventMask = 0;
        for (MediaPlayerEventType type : types) {
            eventMask |= type.value();
        }
        return eventMask;
    }

    public static int notEvents(MediaPlayerEventType ... types) {
        int eventMask = MediaPlayerEventType.ALL.value;
        for (MediaPlayerEventType type : types) {
            eventMask &= ~type.value();
        }
        return eventMask;
    }

    public static boolean set(int value, MediaPlayerEventType type) {
        return (value & type.value()) != 0;
    }

    public static boolean notSet(int value, MediaPlayerEventType type) {
        return (value & type.value()) == 0;
    }
}

