/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_logo_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_marquee_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_stats_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_info_audio_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_info_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_info_video_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_meta_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_navigate_mode_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_state_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_type_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_adjust_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_logo_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_marquee_option_t;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.AbstractMediaPlayer;
import uk.co.caprica.vlcj.player.AudioOutputDeviceType;
import uk.co.caprica.vlcj.player.AudioTrackInfo;
import uk.co.caprica.vlcj.player.DefaultMediaMeta;
import uk.co.caprica.vlcj.player.DeinterlaceMode;
import uk.co.caprica.vlcj.player.LibVlcMediaListIterator;
import uk.co.caprica.vlcj.player.MediaDetails;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerLatch;
import uk.co.caprica.vlcj.player.SpuTrackInfo;
import uk.co.caprica.vlcj.player.TrackDescription;
import uk.co.caprica.vlcj.player.TrackInfo;
import uk.co.caprica.vlcj.player.UnknownTrackInfo;
import uk.co.caprica.vlcj.player.VideoOutputLatch;
import uk.co.caprica.vlcj.player.VideoTrackInfo;
import uk.co.caprica.vlcj.player.events.MediaPlayerEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventFactory;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventType;
import uk.co.caprica.vlcj.player.events.VideoOutputEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultMediaPlayer
extends AbstractMediaPlayer
implements MediaPlayer {
    private static final int DEFAULT_VIDEO_OUTPUT_WAIT_PERIOD = 50;
    private static final int DEFAULT_VIDEO_OUTPUT_TIMEOUT = 5000;
    private final List<MediaPlayerEventListener> eventListenerList = new ArrayList<MediaPlayerEventListener>();
    private final List<VideoOutputEventListener> videoOutputEventListenerList = new ArrayList<VideoOutputEventListener>();
    private final MediaPlayerEventFactory eventFactory = new MediaPlayerEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final ExecutorService videoOutputService = Executors.newSingleThreadExecutor();
    private libvlc_media_player_t mediaPlayerInstance;
    private libvlc_event_manager_t mediaPlayerEventManager;
    private libvlc_callback_t callback;
    private libvlc_media_t mediaInstance;
    private int eventMask = MediaPlayerEventType.ALL.value();
    private String[] standardMediaOptions;
    private libvlc_media_stats_t libvlcMediaStats;
    private boolean repeat;
    private boolean playSubItems;
    private int subItemIndex;
    private String snapshotDirectoryName;
    private Object userData;
    private int videoOutputWaitPeriod = 50;
    private int videoOutputTimeout = 5000;
    private AtomicBoolean released = new AtomicBoolean();

    public DefaultMediaPlayer(LibVlc libvlc, libvlc_instance_t instance) {
        super(libvlc, instance);
        Logger.debug("DefaultMediaPlayer(libvlc={}, instance={})", new Object[]{libvlc, instance});
        this.createInstance();
    }

    @Override
    public void addMediaPlayerEventListener(MediaPlayerEventListener listener) {
        Logger.debug("addMediaPlayerEventListener(listener={})", listener);
        this.eventListenerList.add(listener);
    }

    @Override
    public void removeMediaPlayerEventListener(MediaPlayerEventListener listener) {
        Logger.debug("removeMediaPlayerEventListener(listener={})", listener);
        this.eventListenerList.remove(listener);
    }

    @Override
    public void enableEvents(int eventMask) {
        Logger.debug("enableEvents(eventMask={})", eventMask);
        this.eventMask = eventMask;
    }

    @Override
    public void addVideoOutputEventListener(VideoOutputEventListener listener) {
        Logger.debug("addVideoOutputEventListener(listener={})", listener);
        this.videoOutputEventListenerList.add(listener);
    }

    @Override
    public void removeVideoOutputEventListener(VideoOutputEventListener listener) {
        Logger.debug("removeVideoOutputEventListener(listener={})", listener);
        this.videoOutputEventListenerList.remove(listener);
    }

    @Override
    public void setStandardMediaOptions(String ... options) {
        Logger.debug("setStandardMediaOptions(options={})", Arrays.toString(options));
        this.standardMediaOptions = options;
    }

    @Override
    public void playMedia(String mrl, String ... mediaOptions) {
        Logger.debug("playMedia(mrl={},mediaOptions={})", mrl, Arrays.toString(mediaOptions));
        this.prepareMedia(mrl, mediaOptions);
        this.play();
    }

    @Override
    public void prepareMedia(String mrl, String ... mediaOptions) {
        Logger.debug("prepareMedia(mrl={},mediaOptions={})", mrl, Arrays.toString(mediaOptions));
        this.setMedia(mrl, mediaOptions);
    }

    @Override
    public boolean startMedia(String mrl, String ... mediaOptions) {
        Logger.debug("startMedia(mrl={}, mediaOptions)", mrl, Arrays.toString(mediaOptions));
        this.prepareMedia(mrl, mediaOptions);
        return new MediaPlayerLatch(this).play();
    }

    @Override
    public void parseMedia() {
        Logger.debug("parseMedia()", new Object[0]);
        if (this.mediaInstance == null) {
            throw new IllegalStateException("No media");
        }
        this.libvlc.libvlc_media_parse(this.mediaInstance);
    }

    @Override
    public void requestParseMedia() {
        Logger.debug("requestParseMedia()", new Object[0]);
        if (this.mediaInstance == null) {
            throw new IllegalStateException("No media");
        }
        this.libvlc.libvlc_media_parse_async(this.mediaInstance);
    }

    @Override
    public boolean isMediaParsed() {
        Logger.debug("isMediaParsed()", new Object[0]);
        if (this.mediaInstance != null) {
            return 0 != this.libvlc.libvlc_media_is_parsed(this.mediaInstance);
        }
        throw new IllegalStateException("No media");
    }

    @Override
    public MediaMeta getMediaMeta() {
        Logger.debug("getMediaMeta()", new Object[0]);
        return this.getMediaMeta(this.mediaInstance);
    }

    @Override
    public MediaMeta getMediaMeta(libvlc_media_t media) {
        Logger.debug("getMediaMeta(media={})", new Object[]{media});
        if (media != null) {
            DefaultMediaMeta mediaMeta = new DefaultMediaMeta();
            mediaMeta.setTitle(this.getMeta(libvlc_meta_t.libvlc_meta_Title, media));
            mediaMeta.setArtist(this.getMeta(libvlc_meta_t.libvlc_meta_Artist, media));
            mediaMeta.setGenre(this.getMeta(libvlc_meta_t.libvlc_meta_Genre, media));
            mediaMeta.setCopyright(this.getMeta(libvlc_meta_t.libvlc_meta_Copyright, media));
            mediaMeta.setAlbum(this.getMeta(libvlc_meta_t.libvlc_meta_Album, media));
            mediaMeta.setTrackNumber(this.getMeta(libvlc_meta_t.libvlc_meta_TrackNumber, media));
            mediaMeta.setDescription(this.getMeta(libvlc_meta_t.libvlc_meta_Description, media));
            mediaMeta.setRating(this.getMeta(libvlc_meta_t.libvlc_meta_Rating, media));
            mediaMeta.setDate(this.getMeta(libvlc_meta_t.libvlc_meta_Date, media));
            mediaMeta.setSetting(this.getMeta(libvlc_meta_t.libvlc_meta_Setting, media));
            mediaMeta.setUrl(this.getMeta(libvlc_meta_t.libvlc_meta_URL, media));
            mediaMeta.setLanguage(this.getMeta(libvlc_meta_t.libvlc_meta_Language, media));
            mediaMeta.setNowPlaying(this.getMeta(libvlc_meta_t.libvlc_meta_NowPlaying, media));
            mediaMeta.setPublisher(this.getMeta(libvlc_meta_t.libvlc_meta_Publisher, media));
            mediaMeta.setEncodedBy(this.getMeta(libvlc_meta_t.libvlc_meta_EncodedBy, media));
            mediaMeta.setArtworkUrl(this.getMeta(libvlc_meta_t.libvlc_meta_ArtworkURL, media));
            mediaMeta.setTrackId(this.getMeta(libvlc_meta_t.libvlc_meta_TrackID, media));
            return mediaMeta;
        }
        throw new IllegalStateException("No media");
    }

    @Override
    public MediaMeta getMediaMeta(String mediaPath, boolean parse) {
        Logger.debug("getMediaMeta(mediaPath={},parse={})", mediaPath, parse);
        libvlc_media_t media = this.libvlc.libvlc_media_new_path(this.instance, mediaPath);
        if (media != null) {
            if (parse) {
                Logger.debug("Parsing media...", new Object[0]);
                this.libvlc.libvlc_media_parse(media);
                Logger.debug("Media parsed.", new Object[0]);
            }
            MediaMeta mediaMeta = this.getMediaMeta(media);
            this.libvlc.libvlc_media_release(media);
            return mediaMeta;
        }
        return null;
    }

    @Override
    public List<MediaMeta> getSubItemMediaMeta() {
        Logger.debug("getSubItemMediaMeta()", new Object[0]);
        return this.handleSubItems(new SubItemsHandler<List<MediaMeta>>(){

            @Override
            public List<MediaMeta> subItems(int count, libvlc_media_list_t subItems) {
                ArrayList<MediaMeta> result = new ArrayList<MediaMeta>(count);
                for (libvlc_media_t subItem : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, subItems)) {
                    result.add(DefaultMediaPlayer.this.getMediaMeta(subItem));
                }
                return result;
            }
        });
    }

    @Override
    public void addMediaOptions(String ... mediaOptions) {
        Logger.debug("addMediaOptions(mediaOptions={})", Arrays.toString(mediaOptions));
        if (this.mediaInstance != null) {
            for (String mediaOption : mediaOptions) {
                Logger.debug("mediaOption={}", mediaOption);
                this.libvlc.libvlc_media_add_option(this.mediaInstance, mediaOption);
            }
        } else {
            throw new IllegalStateException("No media");
        }
    }

    @Override
    public void setRepeat(boolean repeat) {
        Logger.debug("setRepeat(repeat={})", repeat);
        this.repeat = repeat;
    }

    @Override
    public boolean getRepeat() {
        Logger.debug("getRepeat()", new Object[0]);
        return this.repeat;
    }

    @Override
    public void setPlaySubItems(boolean playSubItems) {
        Logger.debug("setPlaySubItems(playSubItems={})", playSubItems);
        this.playSubItems = playSubItems;
    }

    @Override
    public int subItemCount() {
        Logger.debug("subItemCount()", new Object[0]);
        return this.handleSubItems(new SubItemsHandler<Integer>(){

            @Override
            public Integer subItems(int count, libvlc_media_list_t subItems) {
                return count;
            }
        });
    }

    @Override
    public int subItemIndex() {
        return this.subItemIndex;
    }

    @Override
    public List<String> subItems() {
        Logger.debug("subItems()", new Object[0]);
        return this.handleSubItems(new SubItemsHandler<List<String>>(){

            @Override
            public List<String> subItems(int count, libvlc_media_list_t subItems) {
                ArrayList<String> result = new ArrayList<String>(count);
                for (libvlc_media_t subItem : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, subItems)) {
                    result.add(DefaultMediaPlayer.this.libvlc.libvlc_media_get_mrl(subItem));
                }
                return result;
            }
        });
    }

    @Override
    public List<libvlc_media_t> subItemsMedia() {
        Logger.debug("subItemsMedia()", new Object[0]);
        return this.handleSubItems(new SubItemsHandler<List<libvlc_media_t>>(){

            @Override
            public List<libvlc_media_t> subItems(int count, libvlc_media_list_t subItems) {
                ArrayList<libvlc_media_t> result = new ArrayList<libvlc_media_t>(count);
                for (libvlc_media_t subItem : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, subItems)) {
                    result.add(subItem);
                }
                return result;
            }
        });
    }

    @Override
    public boolean playNextSubItem(String ... mediaOptions) {
        Logger.debug("playNextSubItem(mediaOptions={})", Arrays.toString(mediaOptions));
        return this.playSubItem(this.subItemIndex + 1, mediaOptions);
    }

    @Override
    public boolean playSubItem(final int index, final String ... mediaOptions) {
        Logger.debug("playSubItem(index={},mediaOptions={})", index, Arrays.toString(mediaOptions));
        return this.handleSubItems(new SubItemsHandler<Boolean>(){

            @Override
            public Boolean subItems(int count, libvlc_media_list_t subItems) {
                if (subItems != null) {
                    libvlc_media_t subItem;
                    Logger.debug("Handling media sub-item...", new Object[0]);
                    Logger.debug("count={}", count);
                    DefaultMediaPlayer.this.subItemIndex = index;
                    Logger.debug("subItemIndex={}", DefaultMediaPlayer.this.subItemIndex);
                    if (DefaultMediaPlayer.this.subItemIndex >= count) {
                        Logger.debug("End of sub-items reached", new Object[0]);
                        if (!DefaultMediaPlayer.this.repeat) {
                            Logger.debug("Do not repeat sub-items", new Object[0]);
                            DefaultMediaPlayer.this.subItemIndex = -1;
                            Logger.debug("Raising events for end of sub-items", new Object[0]);
                            DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaEndOfSubItemsEvent(DefaultMediaPlayer.this.eventMask));
                        } else {
                            Logger.debug("Repeating sub-items", new Object[0]);
                            DefaultMediaPlayer.this.subItemIndex = 0;
                        }
                    }
                    if (DefaultMediaPlayer.this.subItemIndex != -1 && (subItem = DefaultMediaPlayer.this.libvlc.libvlc_media_list_item_at_index(subItems, DefaultMediaPlayer.this.subItemIndex)) != null) {
                        DefaultMediaPlayer.this.libvlc.libvlc_media_player_set_media(DefaultMediaPlayer.this.mediaPlayerInstance, subItem);
                        if (DefaultMediaPlayer.this.standardMediaOptions != null) {
                            for (String standardMediaOption : DefaultMediaPlayer.this.standardMediaOptions) {
                                Logger.debug("standardMediaOption={}", standardMediaOption);
                                DefaultMediaPlayer.this.libvlc.libvlc_media_add_option(subItem, standardMediaOption);
                            }
                        }
                        if (mediaOptions != null) {
                            for (String mediaOption : mediaOptions) {
                                Logger.debug("mediaOption={}", mediaOption);
                                DefaultMediaPlayer.this.libvlc.libvlc_media_add_option(subItem, mediaOption);
                            }
                        }
                        DefaultMediaPlayer.this.libvlc.libvlc_media_player_play(DefaultMediaPlayer.this.mediaPlayerInstance);
                        DefaultMediaPlayer.this.libvlc.libvlc_media_release(subItem);
                        Logger.debug("Raising played event for sub-item {}", DefaultMediaPlayer.this.subItemIndex);
                        DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaSubItemPlayedEvent(DefaultMediaPlayer.this.subItemIndex, DefaultMediaPlayer.this.eventMask));
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public boolean isPlayable() {
        Logger.trace("isPlayable()", new Object[0]);
        return this.libvlc.libvlc_media_player_will_play(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean isPlaying() {
        Logger.trace("isPlaying()", new Object[0]);
        return this.libvlc.libvlc_media_player_is_playing(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean isSeekable() {
        Logger.trace("isSeekable()", new Object[0]);
        return this.libvlc.libvlc_media_player_is_seekable(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean canPause() {
        Logger.trace("canPause()", new Object[0]);
        return this.libvlc.libvlc_media_player_can_pause(this.mediaPlayerInstance) == 1;
    }

    @Override
    public long getLength() {
        Logger.trace("getLength()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_length(this.mediaPlayerInstance);
    }

    @Override
    public long getTime() {
        Logger.trace("getTime()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_time(this.mediaPlayerInstance);
    }

    @Override
    public float getPosition() {
        Logger.trace("getPosition()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_position(this.mediaPlayerInstance);
    }

    @Override
    public float getFps() {
        Logger.trace("getFps()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_fps(this.mediaPlayerInstance);
    }

    @Override
    public float getRate() {
        Logger.trace("getRate()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_rate(this.mediaPlayerInstance);
    }

    @Override
    public int getVideoOutputs() {
        Logger.trace("getVideoOutputs()", new Object[0]);
        return this.libvlc.libvlc_media_player_has_vout(this.mediaPlayerInstance);
    }

    @Override
    public Dimension getVideoDimension() {
        Logger.debug("getVideoDimension()", new Object[0]);
        if (this.getVideoOutputs() > 0) {
            IntByReference px = new IntByReference();
            IntByReference py = new IntByReference();
            int result = this.libvlc.libvlc_video_get_size(this.mediaPlayerInstance, 0, px, py);
            if (result == 0) {
                return new Dimension(px.getValue(), py.getValue());
            }
            Logger.warn("Video size is not available", new Object[0]);
            return null;
        }
        Logger.warn("Can't get video dimension if no video output has been started", new Object[0]);
        return null;
    }

    @Override
    public MediaDetails getMediaDetails() {
        Logger.debug("getMediaDetails()", new Object[0]);
        if (this.isPlaying()) {
            MediaDetails mediaDetails = new MediaDetails();
            mediaDetails.setTitleCount(this.getTitleCount());
            mediaDetails.setVideoTrackCount(this.getVideoTrackCount());
            mediaDetails.setAudioTrackCount(this.getAudioTrackCount());
            mediaDetails.setSpuCount(this.getSpuCount());
            mediaDetails.setTitleDescriptions(this.getTitleDescriptions());
            mediaDetails.setVideoDescriptions(this.getVideoDescriptions());
            mediaDetails.setAudioDescriptions(this.getAudioDescriptions());
            mediaDetails.setSpuDescriptions(this.getSpuDescriptions());
            mediaDetails.setChapterDescriptions(this.getAllChapterDescriptions());
            return mediaDetails;
        }
        Logger.warn("Can't get media meta data if media is not playing", new Object[0]);
        return null;
    }

    @Override
    public String getAspectRatio() {
        Logger.debug("getAspectRatio()", new Object[0]);
        return this.getNativeString(this.libvlc.libvlc_video_get_aspect_ratio(this.mediaPlayerInstance));
    }

    @Override
    public float getScale() {
        Logger.debug("getScale()", new Object[0]);
        return this.libvlc.libvlc_video_get_scale(this.mediaPlayerInstance);
    }

    @Override
    public String getCropGeometry() {
        Logger.debug("getCropGeometry()", new Object[0]);
        return this.getNativeString(this.libvlc.libvlc_video_get_crop_geometry(this.mediaPlayerInstance));
    }

    @Override
    public libvlc_media_stats_t getMediaStatistics() {
        Logger.trace("getMediaStatistics()", new Object[0]);
        return this.getMediaStatistics(this.mediaInstance);
    }

    @Override
    public libvlc_media_stats_t getMediaStatistics(libvlc_media_t media) {
        Logger.trace("getMediaStatistics(media={})", new Object[]{media});
        if (this.isPlaying() && media != null) {
            this.libvlc.libvlc_media_get_stats(media, this.libvlcMediaStats);
        }
        return this.libvlcMediaStats;
    }

    @Override
    public libvlc_state_t getMediaState() {
        Logger.debug("getMediaState()", new Object[0]);
        libvlc_state_t state = null;
        if (this.mediaInstance != null) {
            state = libvlc_state_t.state(this.libvlc.libvlc_media_get_state(this.mediaInstance));
        }
        return state;
    }

    @Override
    public libvlc_state_t getMediaPlayerState() {
        Logger.debug("getMediaPlayerState()", new Object[0]);
        return libvlc_state_t.state(this.libvlc.libvlc_media_player_get_state(this.mediaPlayerInstance));
    }

    @Override
    public int getTitleCount() {
        Logger.debug("getTitleCount()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_title_count(this.mediaPlayerInstance);
    }

    @Override
    public int getTitle() {
        Logger.debug("getTitle()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_title(this.mediaPlayerInstance);
    }

    @Override
    public void setTitle(int title) {
        Logger.debug("setTitle(title={})", title);
        this.libvlc.libvlc_media_player_set_title(this.mediaPlayerInstance, title);
    }

    @Override
    public int getVideoTrackCount() {
        Logger.debug("getVideoTrackCount()", new Object[0]);
        return this.libvlc.libvlc_video_get_track_count(this.mediaPlayerInstance);
    }

    @Override
    public int getVideoTrack() {
        Logger.debug("getVideoTrack()", new Object[0]);
        return this.libvlc.libvlc_video_get_track(this.mediaPlayerInstance);
    }

    @Override
    public void setVideoTrack(int track) {
        Logger.debug("setVideoTrack(track={})", track);
        this.libvlc.libvlc_video_set_track(this.mediaPlayerInstance, track);
    }

    @Override
    public int getAudioTrackCount() {
        Logger.debug("getVideoTrackCount()", new Object[0]);
        return this.libvlc.libvlc_audio_get_track_count(this.mediaPlayerInstance);
    }

    @Override
    public int getAudioTrack() {
        Logger.debug("getAudioTrack()", new Object[0]);
        return this.libvlc.libvlc_audio_get_track(this.mediaPlayerInstance);
    }

    @Override
    public void setAudioTrack(int track) {
        Logger.debug("setAudioTrack(track={})", track);
        this.libvlc.libvlc_audio_set_track(this.mediaPlayerInstance, track);
    }

    @Override
    public void play() {
        Logger.debug("play()", new Object[0]);
        this.onBeforePlay();
        this.libvlc.libvlc_media_player_play(this.mediaPlayerInstance);
    }

    @Override
    public boolean start() {
        return new MediaPlayerLatch(this).play();
    }

    @Override
    public void stop() {
        Logger.debug("stop()", new Object[0]);
        this.libvlc.libvlc_media_player_stop(this.mediaPlayerInstance);
    }

    @Override
    public void setPause(boolean pause) {
        Logger.debug("setPause(pause={})", pause);
        this.libvlc.libvlc_media_player_set_pause(this.mediaPlayerInstance, pause ? 1 : 0);
    }

    @Override
    public void pause() {
        Logger.debug("pause()", new Object[0]);
        this.libvlc.libvlc_media_player_pause(this.mediaPlayerInstance);
    }

    @Override
    public void nextFrame() {
        Logger.debug("nextFrame()", new Object[0]);
        this.libvlc.libvlc_media_player_next_frame(this.mediaPlayerInstance);
    }

    @Override
    public void skip(long delta) {
        Logger.debug("skip(delta={})", delta);
        long current = this.getTime();
        Logger.debug("current={}", current);
        if (current != -1L) {
            this.setTime(current + delta);
        }
    }

    @Override
    public void skip(float delta) {
        Logger.debug("skip(delta={})", Float.valueOf(delta));
        float current = this.getPosition();
        Logger.debug("current={}", Float.valueOf(current));
        if (current != -1.0f) {
            this.setPosition(current + delta);
        }
    }

    @Override
    public void setTime(long time) {
        Logger.debug("setTime(time={})", time);
        this.libvlc.libvlc_media_player_set_time(this.mediaPlayerInstance, time);
    }

    @Override
    public void setPosition(float position) {
        Logger.debug("setPosition(position={})", Float.valueOf(position));
        this.libvlc.libvlc_media_player_set_position(this.mediaPlayerInstance, position);
    }

    @Override
    public int setRate(float rate) {
        Logger.debug("setRate(rate={})", Float.valueOf(rate));
        return this.libvlc.libvlc_media_player_set_rate(this.mediaPlayerInstance, rate);
    }

    @Override
    public void setAspectRatio(String aspectRatio) {
        Logger.debug("setAspectRatio(aspectRatio={})", aspectRatio);
        this.libvlc.libvlc_video_set_aspect_ratio(this.mediaPlayerInstance, aspectRatio);
    }

    @Override
    public void setScale(float factor) {
        Logger.debug("setScale(factor={})", Float.valueOf(factor));
        this.libvlc.libvlc_video_set_scale(this.mediaPlayerInstance, factor);
    }

    @Override
    public void setCropGeometry(String cropGeometry) {
        Logger.debug("setCropGeometry(cropGeometry={})", cropGeometry);
        this.libvlc.libvlc_video_set_crop_geometry(this.mediaPlayerInstance, cropGeometry);
    }

    @Override
    public boolean setAudioOutput(String output) {
        Logger.debug("setAudioOutput(output={})", output);
        return 0 == this.libvlc.libvlc_audio_output_set(this.mediaPlayerInstance, output);
    }

    @Override
    public void setAudioOutputDevice(String output, String outputDeviceId) {
        Logger.debug("setAudioOutputDevice(output={},outputDeviceId={})", output, outputDeviceId);
        this.libvlc.libvlc_audio_output_device_set(this.mediaPlayerInstance, output, outputDeviceId);
    }

    @Override
    public void setAudioOutputDeviceType(AudioOutputDeviceType deviceType) {
        Logger.debug("setAudioOutputDeviceType(deviceType={})", new Object[0]);
        this.libvlc.libvlc_audio_output_set_device_type(this.mediaPlayerInstance, deviceType.intValue());
    }

    @Override
    public AudioOutputDeviceType getAudioOutputDeviceType() {
        Logger.debug("audioOutputDeviceType()", new Object[0]);
        return AudioOutputDeviceType.valueOf(this.libvlc.libvlc_audio_output_get_device_type(this.mediaPlayerInstance));
    }

    @Override
    public void mute() {
        Logger.debug("mute()", new Object[0]);
        this.libvlc.libvlc_audio_toggle_mute(this.mediaPlayerInstance);
    }

    @Override
    public void mute(boolean mute) {
        Logger.debug("mute(mute={})", mute);
        this.libvlc.libvlc_audio_set_mute(this.mediaPlayerInstance, mute ? 1 : 0);
    }

    @Override
    public boolean isMute() {
        Logger.debug("isMute()", new Object[0]);
        return this.libvlc.libvlc_audio_get_mute(this.mediaPlayerInstance) != 0;
    }

    @Override
    public int getVolume() {
        Logger.debug("getVolume()", new Object[0]);
        return this.libvlc.libvlc_audio_get_volume(this.mediaPlayerInstance);
    }

    @Override
    public void setVolume(int volume) {
        Logger.debug("setVolume(volume={})", volume);
        this.libvlc.libvlc_audio_set_volume(this.mediaPlayerInstance, volume);
    }

    @Override
    public int getAudioChannel() {
        Logger.debug("getAudioChannel()", new Object[0]);
        return this.libvlc.libvlc_audio_get_channel(this.mediaPlayerInstance);
    }

    @Override
    public void setAudioChannel(int channel) {
        Logger.debug("setAudioChannel(channel={})", channel);
        this.libvlc.libvlc_audio_set_channel(this.mediaPlayerInstance, channel);
    }

    @Override
    public long getAudioDelay() {
        Logger.debug("getAudioDelay()", new Object[0]);
        return this.libvlc.libvlc_audio_get_delay(this.mediaPlayerInstance);
    }

    @Override
    public void setAudioDelay(long delay) {
        Logger.debug("setAudioDelay(delay={})", delay);
        this.libvlc.libvlc_audio_set_delay(this.mediaPlayerInstance, delay);
    }

    @Override
    public int getChapterCount() {
        Logger.trace("getChapterCount()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_chapter_count(this.mediaPlayerInstance);
    }

    @Override
    public int getChapter() {
        Logger.trace("getChapter()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void setChapter(int chapterNumber) {
        Logger.debug("setChapter(chapterNumber={})", chapterNumber);
        this.libvlc.libvlc_media_player_set_chapter(this.mediaPlayerInstance, chapterNumber);
    }

    @Override
    public void nextChapter() {
        Logger.debug("nextChapter()", new Object[0]);
        this.libvlc.libvlc_media_player_next_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void previousChapter() {
        Logger.debug("previousChapter()", new Object[0]);
        this.libvlc.libvlc_media_player_previous_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void menuActivate() {
        Logger.debug("menuActivate()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_activate.intValue());
    }

    @Override
    public void menuUp() {
        Logger.debug("menuUp()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_up.intValue());
    }

    @Override
    public void menuDown() {
        Logger.debug("menuDown()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_down.intValue());
    }

    @Override
    public void menuLeft() {
        Logger.debug("menuLeft()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_left.intValue());
    }

    @Override
    public void menuRight() {
        Logger.debug("menuRight()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_right.intValue());
    }

    @Override
    public int getSpuCount() {
        Logger.debug("getSpuCount()", new Object[0]);
        return this.libvlc.libvlc_video_get_spu_count(this.mediaPlayerInstance);
    }

    @Override
    public int getSpu() {
        Logger.debug("getSpu()", new Object[0]);
        return this.libvlc.libvlc_video_get_spu(this.mediaPlayerInstance);
    }

    @Override
    public void setSpu(int spu) {
        Logger.debug("setSpu(spu={})", spu);
        int spuCount = this.getSpuCount();
        Logger.debug("spuCount={}", spuCount);
        if (spuCount != 0 && spu <= spuCount) {
            this.libvlc.libvlc_video_set_spu(this.mediaPlayerInstance, spu);
        } else {
            Logger.debug("Ignored out of range spu number {} because spu count is {}", spu, spuCount);
        }
    }

    @Override
    public void cycleSpu() {
        Logger.debug("cycleSpu()", new Object[0]);
        int spu = this.getSpu();
        int spuCount = this.getSpuCount();
        spu = spu >= spuCount ? 0 : ++spu;
        this.setSpu(spu);
    }

    @Override
    public void setSubTitleFile(String subTitleFileName) {
        Logger.debug("setSubTitleFile(subTitleFileName={})", subTitleFileName);
        this.libvlc.libvlc_video_set_subtitle_file(this.mediaPlayerInstance, subTitleFileName);
    }

    @Override
    public void setSubTitleFile(File subTitleFile) {
        Logger.debug("setSubTitleFile(subTitleFile={})", subTitleFile);
        this.setSubTitleFile(subTitleFile.getAbsolutePath());
    }

    @Override
    public List<TrackDescription> getTitleDescriptions() {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getTitleDescriptions()", new Object[0]);
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_title_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    @Override
    public List<TrackDescription> getVideoDescriptions() {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getVideoDescriptions()", new Object[0]);
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_track_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    @Override
    public List<TrackDescription> getAudioDescriptions() {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getAudioDescriptions()", new Object[0]);
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_audio_get_track_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    @Override
    public List<TrackDescription> getSpuDescriptions() {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getSpuDescriptions()", new Object[0]);
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_spu_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    @Override
    public List<String> getChapterDescriptions(int title) {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getChapterDescriptions(title={})", title);
        ArrayList<String> trackDescriptionList = new ArrayList<String>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_chapter_description(this.mediaPlayerInstance, title);
        while (trackDescription != null) {
            trackDescriptionList.add(trackDescription.psz_name);
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    @Override
    public List<String> getChapterDescriptions() {
        Logger.debug("getChapterDescriptions()", new Object[0]);
        return this.getChapterDescriptions(this.getTitle());
    }

    @Override
    public List<List<String>> getAllChapterDescriptions() {
        Logger.debug("getAllChapterDescriptions()", new Object[0]);
        int titleCount = this.getTitleCount();
        ArrayList<List<String>> result = new ArrayList<List<String>>(titleCount);
        for (int i = 0; i < titleCount; ++i) {
            result.add(this.getChapterDescriptions(i));
        }
        return result;
    }

    @Override
    public List<TrackInfo> getTrackInfo() {
        Logger.debug("getTrackInfo()", new Object[0]);
        return this.getTrackInfo(this.mediaInstance);
    }

    @Override
    public List<TrackInfo> getTrackInfo(libvlc_media_t media) {
        Logger.debug("getTrackInfo(media={})", new Object[]{media});
        if (media != null) {
            PointerByReference tracks = new PointerByReference();
            int numberOfTracks = this.libvlc.libvlc_media_get_tracks_info(media, tracks);
            Logger.trace("numberOfTracks={}", numberOfTracks);
            ArrayList<TrackInfo> result = new ArrayList<TrackInfo>(numberOfTracks);
            if (numberOfTracks > 0) {
                libvlc_media_track_info_t[] trackInfoArray;
                libvlc_media_track_info_t trackInfos = new libvlc_media_track_info_t(tracks.getValue());
                block6: for (libvlc_media_track_info_t trackInfo : trackInfoArray = (libvlc_media_track_info_t[])trackInfos.toArray(numberOfTracks)) {
                    switch (libvlc_track_type_t.valueOf(trackInfo.i_type)) {
                        case libvlc_track_unknown: {
                            result.add(new UnknownTrackInfo(trackInfo.i_codec, trackInfo.i_id, trackInfo.i_profile, trackInfo.i_level));
                            continue block6;
                        }
                        case libvlc_track_video: {
                            trackInfo.u.setType(libvlc_media_track_info_video_t.ByValue.class);
                            trackInfo.u.read();
                            result.add(new VideoTrackInfo(trackInfo.i_codec, trackInfo.i_id, trackInfo.i_profile, trackInfo.i_level, trackInfo.u.video.i_width, trackInfo.u.video.i_height));
                            continue block6;
                        }
                        case libvlc_track_audio: {
                            trackInfo.u.setType(libvlc_media_track_info_audio_t.ByValue.class);
                            trackInfo.u.read();
                            result.add(new AudioTrackInfo(trackInfo.i_codec, trackInfo.i_id, trackInfo.i_profile, trackInfo.i_level, trackInfo.u.audio.i_channels, trackInfo.u.audio.i_rate));
                            continue block6;
                        }
                        case libvlc_track_text: {
                            result.add(new SpuTrackInfo(trackInfo.i_codec, trackInfo.i_id, trackInfo.i_profile, trackInfo.i_level));
                        }
                    }
                }
            }
            this.libvlc.libvlc_free(tracks.getValue());
            return result;
        }
        return null;
    }

    @Override
    public List<List<TrackInfo>> getSubItemTrackInfo() {
        Logger.debug("getSubItemTrackInfo()", new Object[0]);
        return this.handleSubItems(new SubItemsHandler<List<List<TrackInfo>>>(){

            @Override
            public List<List<TrackInfo>> subItems(int count, libvlc_media_list_t subItems) {
                ArrayList<List<TrackInfo>> result = new ArrayList<List<TrackInfo>>(count);
                for (libvlc_media_t subItem : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, subItems)) {
                    result.add(DefaultMediaPlayer.this.getTrackInfo(subItem));
                }
                return result;
            }
        });
    }

    @Override
    public void setSnapshotDirectory(String snapshotDirectoryName) {
        Logger.debug("setSnapshotDirectory(snapshotDirectoryName={})", snapshotDirectoryName);
        this.snapshotDirectoryName = snapshotDirectoryName;
    }

    @Override
    public boolean saveSnapshot() {
        Logger.debug("saveSnapshot()", new Object[0]);
        return this.saveSnapshot(0, 0);
    }

    @Override
    public boolean saveSnapshot(int width, int height) {
        Logger.debug("saveSnapshot(width={},height={})", width, height);
        File snapshotDirectory = new File(this.snapshotDirectoryName == null ? System.getProperty("user.home") : this.snapshotDirectoryName);
        File snapshotFile = new File(snapshotDirectory, "vlcj-snapshot-" + System.currentTimeMillis() + ".png");
        return this.saveSnapshot(snapshotFile, width, height);
    }

    @Override
    public boolean saveSnapshot(File file) {
        Logger.debug("saveSnapshot(file={})", file);
        return this.saveSnapshot(file, 0, 0);
    }

    @Override
    public boolean saveSnapshot(File file, int width, int height) {
        Logger.debug("saveSnapshot(file={},width={},height={})", file, width, height);
        File snapshotDirectory = file.getParentFile();
        if (snapshotDirectory == null) {
            snapshotDirectory = new File(".");
            Logger.debug("No directory specified for snapshot, snapshot will be saved to {}", snapshotDirectory.getAbsolutePath());
        }
        if (!snapshotDirectory.exists()) {
            snapshotDirectory.mkdirs();
        }
        if (snapshotDirectory.exists()) {
            boolean snapshotTaken = this.libvlc.libvlc_video_take_snapshot(this.mediaPlayerInstance, 0, file.getAbsolutePath(), width, height) == 0;
            Logger.debug("snapshotTaken={}", snapshotTaken);
            return snapshotTaken;
        }
        throw new RuntimeException("Directory does not exist and could not be created for '" + file.getAbsolutePath() + "'");
    }

    @Override
    public BufferedImage getSnapshot() {
        Logger.debug("getSnapshot()", new Object[0]);
        return this.getSnapshot(0, 0);
    }

    @Override
    public BufferedImage getSnapshot(int width, int height) {
        BufferedImage snapshotImage2;
        block8: {
            boolean deleted;
            File file;
            block6: {
                BufferedImage bufferedImage;
                block7: {
                    BufferedImage snapshotImage2;
                    Logger.debug("getSnapshot(width={},height={})", width, height);
                    file = null;
                    file = File.createTempFile("vlcj-snapshot-", ".png");
                    Logger.debug("file={}", file.getAbsolutePath());
                    if (!this.saveSnapshot(file, width, height)) break block6;
                    bufferedImage = snapshotImage2 = ImageIO.read(file);
                    if (file == null) break block7;
                    boolean deleted2 = file.delete();
                    Logger.debug("deleted={}", deleted2);
                }
                return bufferedImage;
            }
            try {
                snapshotImage2 = null;
                if (file == null) break block8;
                deleted = file.delete();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Failed to get snapshot image", e);
                }
                catch (Throwable throwable) {
                    if (file != null) {
                        boolean deleted3 = file.delete();
                        Logger.debug("deleted={}", deleted3);
                    }
                    throw throwable;
                }
            }
            Logger.debug("deleted={}", deleted);
        }
        return snapshotImage2;
    }

    @Override
    public void enableLogo(boolean enable) {
        Logger.debug("enableLogo(enable={})", enable);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_enable.intValue(), enable ? 1 : 0);
    }

    @Override
    public void setLogoOpacity(int opacity) {
        Logger.debug("setLogoOpacity(opacity={})", opacity);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacity);
    }

    @Override
    public void setLogoOpacity(float opacity) {
        Logger.debug("setLogoOpacity(opacity={})", Float.valueOf(opacity));
        int opacityValue = Math.round(opacity * 255.0f);
        Logger.debug("opacityValue={}", opacityValue);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacityValue);
    }

    @Override
    public void setLogoLocation(int x, int y) {
        Logger.debug("setLogoLocation(x={},y={})", x, y);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_x.intValue(), x);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_y.intValue(), y);
    }

    @Override
    public void setLogoPosition(libvlc_logo_position_e position) {
        Logger.debug("setLogoPosition(position={})", new Object[]{position});
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_position.intValue(), position.intValue());
    }

    @Override
    public void setLogoFile(String logoFile) {
        Logger.debug("setLogoFile(logoFile={})", logoFile);
        this.libvlc.libvlc_video_set_logo_string(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_file.intValue(), logoFile);
    }

    @Override
    public void setLogoImage(RenderedImage logoImage) {
        block5: {
            boolean deleted;
            Logger.debug("setLogoImage(logoImage={})", logoImage);
            File file = null;
            try {
                file = File.createTempFile("vlcj-logo-", ".png");
                ImageIO.write(logoImage, "png", file);
                this.setLogoFile(file.getAbsolutePath());
                if (file == null) break block5;
                deleted = file.delete();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Failed to set logo image", e);
                }
                catch (Throwable throwable) {
                    if (file != null) {
                        boolean deleted2 = file.delete();
                        Logger.debug("deleted={}", deleted2);
                    }
                    throw throwable;
                }
            }
            Logger.debug("deleted={}", deleted);
        }
    }

    @Override
    public void enableMarquee(boolean enable) {
        Logger.debug("enableMarquee(enable={})", enable);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Enable.intValue(), enable ? 1 : 0);
    }

    @Override
    public void setMarqueeText(String text) {
        Logger.debug("setMarqueeText(text={})", text);
        this.libvlc.libvlc_video_set_marquee_string(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Text.intValue(), text);
    }

    @Override
    public void setMarqueeColour(Color colour) {
        Logger.debug("setMarqueeColour(colour={})", colour);
        this.setMarqueeColour(colour.getRGB() & 0xFFFFFF);
    }

    @Override
    public void setMarqueeColour(int colour) {
        Logger.debug("setMarqueeColour(colour={})", colour);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Color.intValue(), colour);
    }

    @Override
    public void setMarqueeOpacity(int opacity) {
        Logger.debug("setMarqueeOpacity(opacity={})", opacity);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), opacity);
    }

    @Override
    public void setMarqueeOpacity(float opacity) {
        Logger.debug("setMarqueeOpacity(opacity={})", Float.valueOf(opacity));
        int opacityValue = Math.round(opacity * 255.0f);
        Logger.debug("opacityValue={}", opacityValue);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), opacityValue);
    }

    @Override
    public void setMarqueeSize(int size) {
        Logger.debug("setMarqueeSize(size={})", size);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Size.intValue(), size);
    }

    @Override
    public void setMarqueeTimeout(int timeout) {
        Logger.debug("setMarqueeTimeout(timeout={})", timeout);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Timeout.intValue(), timeout);
    }

    @Override
    public void setMarqueeLocation(int x, int y) {
        Logger.debug("setMarqueeLocation(x={},y={})", x, y);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_X.intValue(), x);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Y.intValue(), y);
    }

    @Override
    public void setMarqueePosition(libvlc_marquee_position_e position) {
        Logger.debug("setMarqueePosition(position={})", new Object[]{position});
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Position.intValue(), position.intValue());
    }

    @Override
    public void setDeinterlace(DeinterlaceMode deinterlaceMode) {
        Logger.debug("setDeinterlace(deinterlaceMode={})", new Object[]{deinterlaceMode});
        this.libvlc.libvlc_video_set_deinterlace(this.mediaPlayerInstance, deinterlaceMode.mode());
    }

    @Override
    public void setAdjustVideo(boolean adjustVideo) {
        Logger.debug("setAdjustVideo(adjustVideo={})", adjustVideo);
        this.libvlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue(), adjustVideo ? 1 : 0);
    }

    @Override
    public boolean isAdjustVideo() {
        Logger.debug("isAdjustVideo()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue()) == 1;
    }

    @Override
    public float getContrast() {
        Logger.debug("getContrast()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue());
    }

    @Override
    public void setContrast(float contrast) {
        Logger.debug("setContrast(contrast={})", Float.valueOf(contrast));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue(), contrast);
    }

    @Override
    public float getBrightness() {
        Logger.debug("getBrightness()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue());
    }

    @Override
    public void setBrightness(float brightness) {
        Logger.debug("setBrightness(brightness={})", Float.valueOf(brightness));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue(), brightness);
    }

    @Override
    public int getHue() {
        Logger.debug("getHue()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue());
    }

    @Override
    public void setHue(int hue) {
        Logger.debug("setHue(hue={})", hue);
        this.libvlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue(), hue);
    }

    @Override
    public float getSaturation() {
        Logger.debug("getSaturation()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue());
    }

    @Override
    public void setSaturation(float saturation) {
        Logger.debug("setSaturation(saturation={})", Float.valueOf(saturation));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue(), saturation);
    }

    @Override
    public float getGamma() {
        Logger.debug("getGamma()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue());
    }

    @Override
    public void setGamma(float gamma) {
        Logger.debug("setGamma(gamma={})", Float.valueOf(gamma));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue(), gamma);
    }

    @Override
    public String mrl(libvlc_media_t mediaInstance) {
        Logger.debug("mrl(mediaInstance={})", new Object[]{mediaInstance});
        return this.libvlc.libvlc_media_get_mrl(mediaInstance);
    }

    @Override
    public Object userData() {
        Logger.debug("userData()", new Object[0]);
        return this.userData;
    }

    @Override
    public void userData(Object userData) {
        Logger.debug("userData(userData={})", userData);
        this.userData = userData;
    }

    @Override
    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
            this.onAfterRelease();
        }
    }

    @Override
    public final libvlc_media_player_t mediaPlayerInstance() {
        return this.mediaPlayerInstance;
    }

    public void setVideoOutputWaitPeriod(int videoOutputWaitPeriod, int videoOutputTimeout) {
        Logger.debug("setVideoOutputWaitPeriod(videoOutputWaitPeriod={},videoOutputTimeout={})", videoOutputWaitPeriod, videoOutputTimeout);
        this.videoOutputWaitPeriod = videoOutputWaitPeriod;
        this.videoOutputTimeout = videoOutputTimeout;
    }

    protected void onBeforePlay() {
    }

    protected void onAfterRelease() {
    }

    private void createInstance() {
        Logger.debug("createInstance()", new Object[0]);
        this.mediaPlayerInstance = this.libvlc.libvlc_media_player_new(this.instance);
        Logger.debug("mediaPlayerInstance={}", new Object[]{this.mediaPlayerInstance});
        this.mediaPlayerEventManager = this.libvlc.libvlc_media_player_event_manager(this.mediaPlayerInstance);
        Logger.debug("mediaPlayerEventManager={}", new Object[]{this.mediaPlayerEventManager});
        this.registerEventListener();
        this.eventListenerList.add(new VideoOutputEventHandler());
        this.eventListenerList.add(new NewMediaEventHandler());
        this.eventListenerList.add(new RepeatPlayEventHandler());
        this.eventListenerList.add(new SubItemEventHandler());
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        Logger.debug("Detach media events...", new Object[0]);
        this.deregisterMediaEventListener();
        Logger.debug("Media events detached.", new Object[0]);
        if (this.mediaInstance != null) {
            Logger.debug("Release media...", new Object[0]);
            this.libvlc.libvlc_media_release(this.mediaInstance);
            Logger.debug("Media released.", new Object[0]);
        }
        Logger.debug("Detach media player events...", new Object[0]);
        this.deregisterEventListener();
        Logger.debug("Media player events detached.", new Object[0]);
        this.eventListenerList.clear();
        this.videoOutputEventListenerList.clear();
        if (this.mediaPlayerInstance != null) {
            Logger.debug("Release media player...", new Object[0]);
            this.libvlc.libvlc_media_player_release(this.mediaPlayerInstance);
            Logger.debug("Media player released.", new Object[0]);
        }
        Logger.debug("Shut down listeners...", new Object[0]);
        this.listenersService.shutdown();
        Logger.debug("Listeners shut down.", new Object[0]);
        this.videoOutputService.shutdown();
    }

    private void registerEventListener() {
        Logger.debug("registerEventListener()", new Object[0]);
        this.callback = new VlcVideoPlayerCallback();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaPlayerLengthChanged.intValue()) continue;
            Logger.debug("event={}", new Object[]{event});
            int result = this.libvlc.libvlc_event_attach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            Logger.debug("result={}", result);
        }
    }

    private void deregisterEventListener() {
        Logger.debug("deregisterEventListener()", new Object[0]);
        if (this.callback != null) {
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaPlayerLengthChanged.intValue()) continue;
                Logger.debug("event={}", new Object[]{event});
                this.libvlc.libvlc_event_detach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void registerMediaEventListener() {
        Logger.debug("registerMediaEventListener()", new Object[0]);
        if (this.mediaInstance != null) {
            libvlc_event_manager_t mediaEventManager = this.libvlc.libvlc_media_event_manager(this.mediaInstance);
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaStateChanged.intValue()) continue;
                Logger.debug("event={}", new Object[]{event});
                int result = this.libvlc.libvlc_event_attach(mediaEventManager, event.intValue(), this.callback, null);
                Logger.debug("result={}", result);
            }
        }
    }

    private void deregisterMediaEventListener() {
        Logger.debug("deregisterMediaEventListener()", new Object[0]);
        if (this.mediaInstance != null) {
            libvlc_event_manager_t mediaEventManager = this.libvlc.libvlc_media_event_manager(this.mediaInstance);
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaStateChanged.intValue()) continue;
                Logger.debug("event={}", new Object[]{event});
                this.libvlc.libvlc_event_detach(mediaEventManager, event.intValue(), this.callback, null);
            }
            Object var1_1 = null;
        }
    }

    private void raiseEvent(MediaPlayerEvent mediaPlayerEvent) {
        Logger.trace("raiseEvent(mediaPlayerEvent={}", mediaPlayerEvent);
        if (mediaPlayerEvent != null) {
            this.listenersService.submit(new NotifyEventListenersRunnable(mediaPlayerEvent));
        }
    }

    private boolean setMedia(String media, String ... mediaOptions) {
        Logger.debug("setMedia(media={},mediaOptions={})", media, Arrays.toString(mediaOptions));
        if (this.mediaInstance != null) {
            this.deregisterMediaEventListener();
            this.libvlc.libvlc_media_release(this.mediaInstance);
            this.mediaInstance = null;
        }
        this.subItemIndex = -1;
        this.mediaInstance = this.libvlc.libvlc_media_new_path(this.instance, media);
        Logger.debug("mediaInstance={}", new Object[]{this.mediaInstance});
        if (this.mediaInstance != null) {
            if (this.standardMediaOptions != null) {
                for (String standardMediaOption : this.standardMediaOptions) {
                    Logger.debug("standardMediaOption={}", standardMediaOption);
                    this.libvlc.libvlc_media_add_option(this.mediaInstance, standardMediaOption);
                }
            }
            if (mediaOptions != null) {
                for (String mediaOption : mediaOptions) {
                    Logger.debug("mediaOption={}", mediaOption);
                    this.libvlc.libvlc_media_add_option(this.mediaInstance, mediaOption);
                }
            }
            this.registerMediaEventListener();
            this.libvlc.libvlc_media_player_set_media(this.mediaPlayerInstance, this.mediaInstance);
        }
        this.libvlcMediaStats = new libvlc_media_stats_t();
        return this.mediaInstance != null;
    }

    private String getMeta(libvlc_meta_t metaType, libvlc_media_t media) {
        Logger.trace("getMeta(metaType={},media={})", new Object[]{metaType, media});
        if (media != null) {
            return this.getNativeString(this.libvlc.libvlc_media_get_meta(media, metaType.intValue()));
        }
        throw new IllegalStateException("No media");
    }

    private <T> T handleSubItems(SubItemsHandler<T> subItemsHandler) {
        block5: {
            T t;
            block6: {
                Logger.debug("handleSubItems()", new Object[0]);
                libvlc_media_list_t subItemList = null;
                try {
                    if (this.mediaInstance == null) break block5;
                    subItemList = this.libvlc.libvlc_media_subitems(this.mediaInstance);
                    Logger.debug("subItemList={}", new Object[]{subItemList});
                    if (subItemList != null) {
                        this.libvlc.libvlc_media_list_lock(subItemList);
                    }
                    t = subItemsHandler.subItems(subItemList != null ? this.libvlc.libvlc_media_list_count(subItemList) : 0, subItemList);
                    if (subItemList == null) break block6;
                    this.libvlc.libvlc_media_list_unlock(subItemList);
                    this.libvlc.libvlc_media_list_release(subItemList);
                }
                catch (Throwable throwable) {
                    if (subItemList != null) {
                        this.libvlc.libvlc_media_list_unlock(subItemList);
                        this.libvlc.libvlc_media_list_release(subItemList);
                    }
                    throw throwable;
                }
            }
            return t;
        }
        throw new IllegalStateException("No media");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SubItemsHandler<T> {
        public T subItems(int var1, libvlc_media_list_t var2);
    }

    private final class SubItemEventHandler
    extends MediaPlayerEventAdapter {
        private SubItemEventHandler() {
        }

        public void finished(MediaPlayer mediaPlayer) {
            Logger.debug("finished(mediaPlayer={})", mediaPlayer);
            if (DefaultMediaPlayer.this.subItemIndex != -1) {
                Logger.debug("Raising finished event for sub-item {}", DefaultMediaPlayer.this.subItemIndex);
                DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaSubItemFinishedEvent(DefaultMediaPlayer.this.subItemIndex, DefaultMediaPlayer.this.eventMask));
            }
            if (DefaultMediaPlayer.this.playSubItems) {
                DefaultMediaPlayer.this.playNextSubItem(new String[0]);
            }
        }
    }

    private final class RepeatPlayEventHandler
    extends MediaPlayerEventAdapter {
        private RepeatPlayEventHandler() {
        }

        public void finished(MediaPlayer mediaPlayer) {
            Logger.debug("finished(mediaPlayer={})", mediaPlayer);
            if (DefaultMediaPlayer.this.repeat && DefaultMediaPlayer.this.mediaInstance != null) {
                int subItemCount = DefaultMediaPlayer.this.subItemCount();
                Logger.debug("subitemCount={}", subItemCount);
                if (subItemCount == 0) {
                    String mrl = DefaultMediaPlayer.this.libvlc.libvlc_media_get_mrl(DefaultMediaPlayer.this.mediaInstance);
                    Logger.debug("auto repeat mrl={}", mrl);
                    mediaPlayer.playMedia(mrl, new String[0]);
                } else {
                    Logger.debug("Sub-items handling repeat", new Object[0]);
                }
            } else {
                Logger.debug("No repeat", new Object[0]);
            }
        }
    }

    private final class NewMediaEventHandler
    extends MediaPlayerEventAdapter {
        private NewMediaEventHandler() {
        }

        public void mediaChanged(MediaPlayer mediaPlayer) {
            Logger.debug("mediaChanged(mediaPlayer={})", mediaPlayer);
            if (DefaultMediaPlayer.this.subItemIndex() == -1) {
                Logger.debug("Raising event for new media", new Object[0]);
                DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaNewEvent(DefaultMediaPlayer.this.eventMask));
            }
        }
    }

    private final class VideoOutputEventHandler
    extends MediaPlayerEventAdapter {
        private VideoOutputEventHandler() {
        }

        public void playing(MediaPlayer mediaPlayer) {
            Logger.debug("playing(mediaPlayer={})", mediaPlayer);
            if (!DefaultMediaPlayer.this.videoOutputEventListenerList.isEmpty()) {
                DefaultMediaPlayer.this.videoOutputService.execute(new WaitForVideoOutputRunnable());
            }
        }
    }

    private class WaitForVideoOutputRunnable
    implements Runnable {
        private WaitForVideoOutputRunnable() {
        }

        public void run() {
            Logger.debug("run()", new Object[0]);
            boolean videoOutput = new VideoOutputLatch(DefaultMediaPlayer.this, DefaultMediaPlayer.this.videoOutputWaitPeriod, DefaultMediaPlayer.this.videoOutputTimeout).waitForVideoOutput();
            for (int i = DefaultMediaPlayer.this.videoOutputEventListenerList.size() - 1; i >= 0; --i) {
                try {
                    ((VideoOutputEventListener)DefaultMediaPlayer.this.videoOutputEventListenerList.get(i)).videoOutputAvailable(DefaultMediaPlayer.this, videoOutput);
                    continue;
                }
                catch (Throwable t) {
                    Logger.warn("Exception thrown by listener {}", DefaultMediaPlayer.this.videoOutputEventListenerList.get(i));
                }
            }
            Logger.trace("runnable exits", new Object[0]);
        }
    }

    private final class NotifyEventListenersRunnable
    implements Runnable {
        private final MediaPlayerEvent mediaPlayerEvent;

        private NotifyEventListenersRunnable(MediaPlayerEvent mediaPlayerEvent) {
            this.mediaPlayerEvent = mediaPlayerEvent;
        }

        public void run() {
            Logger.trace("run()", new Object[0]);
            for (int i = DefaultMediaPlayer.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener listener = (MediaPlayerEventListener)DefaultMediaPlayer.this.eventListenerList.get(i);
                try {
                    this.mediaPlayerEvent.notify(listener);
                    continue;
                }
                catch (Throwable t) {
                    Logger.warn("Event listener {} threw an exception", t, listener);
                }
            }
            Logger.trace("runnable exits", new Object[0]);
        }
    }

    private final class VlcVideoPlayerCallback
    implements libvlc_callback_t {
        private VlcVideoPlayerCallback() {
        }

        public void callback(libvlc_event_t event, Pointer userData) {
            Logger.trace("callback(event={},userData={})", new Object[]{event, userData});
            if (!DefaultMediaPlayer.this.eventListenerList.isEmpty()) {
                DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createEvent(event, DefaultMediaPlayer.this.eventMask));
            }
        }
    }
}

