/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.component;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.CanvasVideoSurface;

public class EmbeddedMediaPlayerComponent
extends Panel {
    protected static final String[] DEFAULT_FACTORY_ARGUMENTS = new String[]{"--no-plugins-cache", "--no-video-title-show", "--no-snapshot-preview", "--quiet", "--quiet-synchro", "--intf", "dummy"};
    private final MediaPlayerFactory mediaPlayerFactory = this.onGetMediaPlayerFactory();
    private final EmbeddedMediaPlayer mediaPlayer = this.mediaPlayerFactory.newEmbeddedMediaPlayer(this.onGetFullScreenStrategy());
    private final Canvas canvas = this.onGetCanvas();
    private final CanvasVideoSurface videoSurface = this.mediaPlayerFactory.newVideoSurface(this.canvas);
    private Cursor blankCursor;

    public EmbeddedMediaPlayerComponent() {
        this.mediaPlayer.setVideoSurface(this.videoSurface);
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
    }

    public final EmbeddedMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public final Canvas getVideoSurface() {
        return this.canvas;
    }

    public final void setCursorEnabled(boolean enabled) {
        this.setCursor(enabled ? null : this.getBlankCursor());
    }

    public final void release() {
        this.onBeforeRelease();
        this.mediaPlayer.release();
        this.mediaPlayerFactory.release();
        this.onAfterRelease();
    }

    private Cursor getBlankCursor() {
        if (this.blankCursor == null) {
            BufferedImage blankImage = new BufferedImage(1, 1, 2);
            this.blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(blankImage, new Point(0, 0), "");
        }
        return this.blankCursor;
    }

    protected MediaPlayerFactory onGetMediaPlayerFactory() {
        return new MediaPlayerFactory(this.onGetMediaPlayerFactoryArgs());
    }

    protected String[] onGetMediaPlayerFactoryArgs() {
        return DEFAULT_FACTORY_ARGUMENTS;
    }

    protected FullScreenStrategy onGetFullScreenStrategy() {
        return null;
    }

    protected Canvas onGetCanvas() {
        Canvas canvas = new Canvas();
        canvas.setBackground(Color.black);
        return canvas;
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }
}

