/**
 * Kopiowanie pliku.
 *
 * Użycie:
 *     copy <plik_źródłowy> <plik_docelowy>
 */

#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#ifndef O_BINARY
#define O_BINARY 0	// Definicja O_BINARY, jeżeli jej nie ma.
#endif // O_BINARY

int main(int argc, char* argv[])
{
    if (argc != 3) {
        fprintf(stderr, "Użycie: %s <plik_źródłowy> <plik_docelowy>\n", argv[0]);
        exit(8);
    }

    // Deskryptor pliku wejściowego.
    int inFd = open(argv[1], O_RDONLY|O_BINARY);

    if (inFd < 0) {
        fprintf(stderr, "BŁĄD: nie można otworzyć pliku %s do odczytu\n", argv[1]);
        exit(8);
    }

    // Deskryptor pliku wyjściowego.
    int outFd = open(argv[2], O_WRONLY|O_CREAT|O_BINARY, 0666);
    if (outFd < 0) {
        fprintf(stderr, "BŁĄD: nie można otworzyć pliku %s do zapisu\n", argv[2]);
        exit(8);
    }

    while (true)
    {
        char buffer[1024];  // Bufor odczytywanych i zapisywanych danych.
        ssize_t readSize;   // Liczba ostatnio odczytanych bajtów.
        
        readSize = read(inFd, buffer, sizeof(buffer));
        if (readSize < 0) {
            fprintf(stderr, "BŁĄD: problem z odczytem pliku %s\n", argv[1]);
            exit(8);
        }
        if (readSize == 0)
            break;
        
        if (write(outFd, buffer, readSize) != readSize) {
            fprintf(stderr, "BŁĄD: problem z zapisem pliku %s\n", argv[2]);
            exit(8);
        }
    }
    close(inFd);
    close(outFd);
    return (0);
}

