/**
 * Skopiuj plik infile.bin do pliku outfile.bin.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

int main()
{
    // Plik wejściowy.
    FILE* inFile = fopen("infile.bin", "rb");
    if (inFile == NULL) {
        fprintf(stderr, "BLAD: Nie mozna otworzyc pliku infile.bin\n");
        exit(8);
    }
    // Plik wyjściowy.
    FILE* outFile = fopen("outfile.bin", "wb");
    if (outFile == NULL) {
        fprintf(stderr, "BLAD: Nie mozna utworzyc pliku outfile.bin\n");
        exit(8);
    }
    char buffer[512];   // Bufor danych.

    while (true) {
        // Odczytaj dane, weź rozmiar.
        ssize_t readSize = fread(buffer, 1, sizeof(buffer), inFile);
        if (readSize < 0) {
            fprintf(stderr, "BLAD: Zaobserwowano blad odczytu\n");
            exit(8);
        }
        if (readSize == 0) {
            break;
        }
        if (fwrite(buffer, 1, readSize, outFile) != (size_t)readSize) {
            fprintf(stderr, "BLAD: Zaobserwowano blad zapisu\n");
            exit(8);
        }
    }
    fclose(inFile);
    fclose(outFile);
    return (0);
}


