// FourOfAKind.java

/**
 *  <code>FourOfAKind</code> implementuje gr karcian rozgrywan midzy dwoma graczami:
 *  czowiekiem i komputerem. Gr rozgrywa si przy uyciu standardowej talii 52 kart,
 *  a jej celem jest ogranie komputera w ten sposb, by jako pierwszy gracz 
 *  zebra cztery karty tej samej rangi (na przykad cztery asy).
 *
 *  <p>
 *  Gra rozpoczyna si od potasowania talii kart i pooenia jej grzbietem do gry.
 *  Kady gracz bierze kart z gry talii. Gracz, ktry wycignie wysz kart
 *  (najwysz kart jest krl) rozdaje cztery karty najpierw drugiemu graczowi,
 *  a potem sobie. Nastpnie gracz, ktry rozdawa karty, rozpoczyna parti.
 *
 *  <p>
 *  Gracz sprawdza karty i ustala, ktre z nich daj najwiksze szanse na zebranie karety.
 *  Nastpnie gracz odrzuca jedn kart na stos kart odrzuconych i pobiera jedn kart
 *  z gry talii. Jeeli gracz zbierze karet, rzuca wszystkie swoje karty na st
 *  (figurami do gry) i wygrywa parti.
  *
 *  @author Jeff Friesen
 *  @version 1.0
 */
public class FourOfAKind
{
   /**
    *  Gracz - czowiek
    */
   final static int HUMAN = 0;
   /**
    *  Gracz - komputer
    */
   final static int COMPUTER = 1;
   /**
    *  Gwna metoda aplikacji.
    *
    *  @param args tablica argumentw wiersza polece przekazanych do metody
    */
   public static void main(String[] args)
   {
      System.out.println("Witaj w grze Kareta!");
      Deck deck = new Deck(); // talia jest potasowana automatycznie
      DiscardPile discardPile = new DiscardPile();
      Card hCard;
      Card cCard;
      while (true)
      {
         hCard = deck.deal();
         cCard = deck.deal();
         if (hCard.rank() != cCard.rank())
            break;
         deck.putBack(hCard);
         deck.putBack(cCard);
         deck.shuffle(); // zapobieenie sytuacji, w ktrej kada nastpna
      }                  // dwjka kart ma t sam figur
      int curPlayer = HUMAN;
      if (cCard.rank().ordinal() > hCard.rank().ordinal())
         curPlayer = COMPUTER;
      deck.putBack(hCard);
      hCard = null;
      deck.putBack(cCard);
      cCard = null;
      Card[] hCards = new Card[4];
      Card[] cCards = new Card[4];
      if (curPlayer == HUMAN)
         for (int i = 0; i < 4; i++)
         {
            cCards[i] = deck.deal();
            hCards[i] = deck.deal();
         }
      else
         for (int i = 0; i < 4; i++)
         {
            hCards[i] = deck.deal();
            cCards[i] = deck.deal();
         }
      while (true)
      {
         if (curPlayer == HUMAN)
         {
            showHeldCards(hCards);
            int choice = 0;
            while (choice < 'A' || choice > 'D')
            {
               choice = prompt("Ktrej karty chcesz si pozby (A, B, " +
                               "C, D)? ");
               switch (choice)
               {
                  case 'a': choice = 'A'; break;
                  case 'b': choice = 'B'; break;
                  case 'c': choice = 'C'; break;
                  case 'd': choice = 'D';
               }
            }
            discardPile.setTopCard(hCards[choice-'A']);
            hCards[choice-'A'] = deck.deal();
            if (isFourOfAKind(hCards))
            {
               System.out.println();
               System.out.println("Czowiek wygrywa!");
               System.out.println();
               putDown("Karty czowieka:", hCards);
               System.out.println();
               putDown("Karty komputera:", cCards);
               return; // wyjcie z aplikacji przez zakoczenie metody main()
            }
            curPlayer = COMPUTER;
         }
         else
         {
            int choice = leastDesirableCard(cCards);
            discardPile.setTopCard(cCards[choice]);
            cCards[choice] = deck.deal();
            if (isFourOfAKind(cCards))
            {
               System.out.println();
               System.out.println("Komputer wygrywa!");
               System.out.println();
               putDown("Karty komputera:", cCards);
               return; // wyjcie z aplikacji przez zakoczenie metody main()
            }
            curPlayer = HUMAN;
         }
         if (deck.isEmpty())
         {
            while (discardPile.topCard() != null)
               deck.putBack(discardPile.getTopCard());
            deck.shuffle();
         }
      }
   }
   /**
    *  Sprawdza, czy wszystkie obiekty kart <code>Card</code>
    *  przekazane do metody maj t sam rang.
    *
    *  @param cards tabilca obiektw <code>Card</code> przekazana do metody
    *
    *  @return true jeli wszystkie obiekty <code>Card</code> maj t sam rang;
    *  w przeciwnym razie false
    */
   static boolean isFourOfAKind(Card[] cards)
   {
      for (int i = 1; i < cards.length; i++)
         if (cards[i].rank() != cards[0].rank())
            return false;
      return true;
   }
   /**
    *  Wskazuje jedn kart <code>Card</code> spord kart przekazanych do metody,
    *  ktra jest kart najmniej podan do dalszego przetrzymywania.
    *
    *  @param cards tablica obiektw <code>Card</code> przekazana do metody
    *
    *  @return najmniej podana karta (0 to as, krl to 13)
    */
   static int leastDesirableCard(Card[] cards)
   {
      int[] rankCounts = new int[13];
      for (int i = 0; i < cards.length; i++)
         rankCounts[cards[i].rank().ordinal()]++;
      int minCount = Integer.MAX_VALUE;
      int minIndex = -1;
      for (int i = 0; i < rankCounts.length; i++)
         if (rankCounts[i] < minCount && rankCounts[i] != 0)
         {
            minCount = rankCounts[i];
            minIndex = i;
         }
      for (int i = 0; i < cards.length; i++)
         if (cards[i].rank().ordinal() == minIndex)
            return i;
      return 0; // wycznie dla kompilatora (instrukcja nigdy nie powinna zosta wykonana)
   }
   /**
    *  Proba do gracza, aby wpisa znak.
    *
    *  @param msg komunikat prezentowany graczowi
    *
    *  @return wartos cakowitoliczbowa znaku wpisanego przez gracza.
    */
   static int prompt(String msg)
   {
      System.out.print(msg);
      try
      {
         int ch = System.in.read();
         // Usunicie wszystkich kolejnych znakw, w tym koczcego znaku \n,
         // aby nie wpyway one na kolejne wywoanie metody prompt().
         while (System.in.read() != '\n');
         return ch;
      }
      catch (java.io.IOException ioe)
      {
      }
      return 0;
   }
   /**
    *  Wywietlenie komunikatu i wszystkich kart posiadanych przez gracza.
    *  Odpowiada rzuceniu wszystkich kart na st.
    *
    *  @param msg komunikat wywietlany graczowi
    *  @param cards tablica obiektw <code>Card</code> rzucanych na st
    */
   static void putDown(String msg, Card[] cards)
   {
      System.out.println(msg);
      for (int i = 0; i < cards.length; i++)
         System.out.println(cards[i]);
   }
   /**
    *  Wywietlenie posiadanych kart <code>Card</code> w oddzielnych wierszach.
    *  Kady wiersz rozpoczyna si od litery <code>A</code>.
    *
    *  @param cards tablica obiektw <code>Card</code>
    */
   static void showHeldCards(Card[] cards)
   {
      System.out.println();
      System.out.println("Posiadane karty:");
      for (int i = 0; i < cards.length; i++)
         if (cards[i] != null)
            System.out.println((char) ('A'+i) + ". " + cards[i]);
      System.out.println();
   }
}
