// TestMedia.java

import java.io.IOException;

public class TestMedia
{
   public static void main(String[] args)
   {
      if (args.length != 1)
      {
         System.err.println("wywołanie: java TestMedia ścieżka_do_pliku_MP3");
         return;
      }
      try
      {
         Media.ID3 id3Info = Media.getID3Info(args[0]);
         if (id3Info == null)
         {
            System.err.printf("%s nie jest plikiem MP3 lub nie zawiera bloku ID3 %n", args[0]);
            return;
         }
         System.out.println("Tytuł utworu = " + id3Info.getSongTitle());
         System.out.println("Wykonawca = " + id3Info.getArtist());
         System.out.println("Album = " + id3Info.getAlbum());
         System.out.println("Rok = " + id3Info.getYear());
         System.out.println("Komentarz = " +id3Info.getComment());
         System.out.println("Ścieżka = " + id3Info.getTrack());
         System.out.println("Gatunek = " + id3Info.getGenre());
      }
      catch (IOException ioe)
      {
         ioe.printStackTrace();
      }
   }
}
