// Point.java

class Point
{
   private int x, y;
   Point(int x, int y)
   {
      this.x = x;
      this.y = y;
   }
   int getX()
   {
      return x;
   }
   int getY()
   {
      return y;
   }
   @Override public boolean equals(Object o)
   {
      if (!(o instanceof Point))
         return false;
      Point p = (Point) o;
      return p.x == x && p.y == y;
   }
   public static void main(String[] args)
   {
      Point p1 = new Point(10, 20);
      Point p2 = new Point(20, 30);
      Point p3 = new Point(10, 20);
      // Sprawdzenie zwrotnoci
      System.out.println(p1.equals(p1)); // Wynik: true
      // Sprawdzenie symetrii
      System.out.println(p1.equals(p2)); // Wynik: false
      System.out.println(p2.equals(p1)); // Wynik: false
      // Sprawdzenie przechodnioci
      System.out.println(p2.equals(p3)); // Wynik: false
      System.out.println(p1.equals(p3)); // Wynik: true
      // Sprawdzenie wyniku porwnania z null
      System.out.println(p1.equals(null)); // Wynik: false
      // Dodatkowe sprawdzenie przydatnoci operatora instanceof
      System.out.println(p1.equals("abc")); // Wynik: false
   }
}
