// SerializationDemo.java

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializationDemo
{
   final static String FILENAME = "employee.dat";
   public static void main(String[] args)
   {
      ObjectOutputStream oos = null;
      ObjectInputStream ois = null;
      try
      {
         FileOutputStream fos = new FileOutputStream(FILENAME);
         oos = new ObjectOutputStream(fos);
         Employee emp = new Employee("Jan Nowak", 36);
         oos.writeObject(emp);
         oos.close();
         emp = null;
         FileInputStream fis = new FileInputStream(FILENAME);
         ois = new ObjectInputStream(fis);
         emp = (Employee) ois.readObject(); // Rzutowanie (Employee) jest niezbędne.
         ois.close();
         System.out.println(emp.getName());
         System.out.println(emp.getAge());
      }
      catch (ClassNotFoundException cnfe)
      {
         System.err.println(cnfe.getMessage());
         closeFiles(oos, ois);
      }
      catch (IOException ioe)
      {
         System.err.println(ioe.getMessage());
         closeFiles(oos, ois);
      }
   }
   static void closeFiles(ObjectOutputStream oos, ObjectInputStream ois)
   {
      try
      {
         if (oos != null)
            oos.close();
      }
      catch (IOException ioe)
      {
         System.err.println(ioe.getMessage());
      }
      try
      {
         if (ois != null)
            ois.close();
      }
      catch (IOException ioe)
      {
         System.err.println(ioe.getMessage());
      }
   }
}
