// PackageInfo.java

public class PackageInfo
{
   public static void main(String[] args)
   {
      if (args.length == 0)
      {
         System.err.println("uycie: java PackageInfo nazwaPakietu [wersja] [klasa]");
         return;
      }
      if (args.length == 3)
      try
      {
         Class.forName(args[2]);
      }
      catch (ClassNotFoundException cnfe)
      {
         System.err.println("nie mona zaadowa " + args[2]);
         return;
      }
      Package pkg = Package.getPackage(args[0]);
      if (pkg == null)
      {
         System.err.println("Nie znaleziono pakietu " + args[0]);
         return;
      }
      System.out.println("Nazwa: " + pkg.getName());
      System.out.println("Tytu implementacji: " +
                         pkg.getImplementationTitle());
      System.out.println("Dostawca implementacji: " +
                         pkg.getImplementationVendor());
      System.out.println("Wersja implementacji: " +
                         pkg.getImplementationVersion());
      System.out.println("Tytu specyfikacji: " +
                         pkg.getSpecificationTitle());
      System.out.println("Dostawca specyfikacji: " +
                         pkg.getSpecificationVendor());
      System.out.println("Wersja specyfikacji: " +
                         pkg.getSpecificationVersion());
      System.out.println("Upakowany: " + pkg.isSealed());
      if (args.length > 1)
         System.out.println("Zgodny z wersj " + args[1] + ": " +
                            pkg.isCompatibleWith(args[1]));
   }
}