/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 13. Zadania asynchroniczne
 *
 * Listing 13.7. Zrefaktoryzowana implementacja CompletableFutures
 */

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;

public final class CompletableFuturesRefactored {

    private final static Predicate<CompletableFuture<?>> EXCEPTIONALLY =
        Predicate.not(CompletableFuture::isCompletedExceptionally);

    private static <T> Function<Void, List<T>> gatherResultsFn(CompletableFuture<T>... cfs) {

        return unused -> Arrays.stream(cfs)
                               .filter(Predicate.not(CompletableFuturesRefactored.EXCEPTIONALLY))
                               .map(CompletableFuture::join)
                               .toList();
    }

    public static <T> CompletableFuture<List<T>> eachOf(CompletableFuture<T>... cfs) {
        return CompletableFuture.allOf(cfs)
                                .thenApply(gatherResultsFn(cfs));
    }

    public static <T> CompletableFuture<List<T>> bestEffort(CompletableFuture<T>... cfs) {
        return CompletableFuture.allOf(cfs)
                                .exceptionally(ex -> null)
                                .thenApply(gatherResultsFn(cfs));
    }

    private CompletableFuturesRefactored() {
        // POMIJA DOMYLNY KONSTRUKTOR
    }
}
