/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 11. Ewaluacja leniwa
 *
 * Listing 11.1. Ewaluacja leniwa w Javie z wykorzystaniem dostawcw
 */

import java.util.function.IntSupplier;

int addStrict(int x, int y) {
    return x + x;
}

int addLazy(IntSupplier x, IntSupplier y) {
    return x.getAsInt() + x.getAsInt();
}

void strict() {
    addStrict(5, 1 / 0);
}

void lazy() {
    int result = addLazy(() -> 5, () -> 1 / 0);
    System.out.println(result);
}

// strict();
// lazy();
