/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 8. Rwnolege przetwarzanie danych za pomoc strumieni
 *
 * Listing 8.5. Statystyka liczb losowych
 */

import java.util.IntSummaryStatistics;
import java.util.Random;
import java.util.function.IntUnaryOperator;

var elementsCount = 100_000_000; 

IntUnaryOperator multiplyByTwo = in -> in * 2; 

var rnd = new Random(); 

// SEKWENCYJNY IntStream 
var seqStats = rnd.ints(elementsCount)
                  .map(multiplyByTwo)
                  .map(multiplyByTwo)
                  .summaryStatistics();

System.out.println(seqStats);