/*
 * FUNKCYJNE PODEJŚCIE DO JAVY
 * Rozdział 7. Praca ze strumieniami
 *
 * Listing 7.4. Liczenie słów w Wojnie i pokoju
 */

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

var location = Paths.get("../other/war-and-peace.txt"); 

// WZORCE CZYSZCZENIA
var punctionaction = Pattern.compile("\\p{Punct}");
var whitespace     = Pattern.compile("\\s+");
var words          = Pattern.compile("\\w+");

Map<String, Integer> wordCount = null;

try (Stream<String> stream = Files.lines(location)) { 
    wordCount = 
              // CZYSZCZENIE ZAWARTOŚCI
        stream.map(punctionaction::matcher)
              .map(matcher -> matcher.replaceAll(""))
              // DZIELENIE NA SŁOWA
              .map(whitespace::split)
              .flatMap(Arrays::stream)
              // DODATKOWE CZYSZCZENIE 
              .filter(word -> words.matcher(word).matches())
              // NORMALIZACJA
              .map(String::toLowerCase)
              // ZLICZANIE
              .collect(Collectors.toMap(Function.identity(),
                                        word -> 1,
                                        Integer::sum));
} catch (IOException e) {
    // ...
}

System.out.println(wordCount);
