/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 13. Zadania asynchroniczne
 *
 * Listing 13.4. Odpakowywanie zagniedonych etapw
 */

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;

// FUTURE<T>

var executorService = ForkJoinPool.commonPool();

Future<?> futureRunnable =
    executorService.submit(() -> System.out.println("nie zwraca wartoci"));

Future<String> futureCallable =
    executorService.submit(() -> "Witaj, wiecie Async!");


// COMPLETABLEFUTURE<T>

CompletableFuture<Void> completableFutureRunnable =
    CompletableFuture.runAsync(() -> System.out.println("nie zwraca wartoci"));

CompletableFuture<String> completableFutureSupplier =
    CompletableFuture.supplyAsync(() -> "Witaj, wiecie Async!");
