/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 9. Obsuga wartoci null za pomoc typw Optional
 *
 * Listing 9.4. adowanie zawartoci bez typw Optional
 */

import java.util.HashMap;
import java.util.Map;

record Content(boolean isPublished) { }

Content loadFromDB(String identifier) {
    return new Content(false);
}

Map<String, Content> cache = new HashMap<>();

Content get(String contentId) {

    if (contentId == null) {
        return null;
    }
  
    if (contentId.isBlank()) {
        return null;
    }

    var cacheKey = contentId.toLowerCase();

    var content = cache.get(cacheKey);
    if (content == null) {
        content = loadFromDB(contentId);
    }

    if (content == null) {
      return null;
    }

    if (!content.isPublished()) {
        return null;
    }

    return content;
}

get("ABC");
