/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 6. Przetwarzanie danych za pomoc strumieni
 *
 * Listing 6.12. Agregowanie elementw za pomoc operacji reduce
 */

import java.util.ArrayList;
import java.util.stream.Stream;

var fruits = Stream.of("jabko", "pomaracza", "banan", "brzoskwinia")
                   // Wszelkie dodatkowe operacje.
                   // Ten przykad podkrela jedynie
                   // aspect agregacji.
                   .reduce(new ArrayList<>(), 
                           (acc, fruit) -> {
                             var list = new ArrayList<>(acc); 
                             list.add(fruit);
                             return list;
                   },
                   (lhs, rhs) -> {
                     var list = new ArrayList<>(lhs);
                     list.addAll(rhs);
                     return list;
                   });
