/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 5. Praca z rekordami
 */

import java.util.Optional;
import java.time.LocalDate;

public record User(String username,
                   boolean active,
                   Optional<String> group,
                   LocalDateTime lastLogin) {

    public User(String username,
                boolean active,
                String group,
                LocalDateTime lastLogin) {
        this(username,
             active,
             Optional.ofNullable(group),
             lastLogin);
    }
}
