/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 2. Funkcyjna Java
 * 
 * Listing 2.10. Pierwszoklasowe lambdy Javy
 */

// PRZYPISANIE ZMIENNEJ

UnaryOperator<Integer> quadraticFn = x -> x * x;

quadraticFn.apply(5);
// => 25


// ARGUMENT METODY

public Integer apply(Integer input,
                     UnaryOperator<Integer> operation) {

    return operation.apply(input);
}


// WARTO ZWRACANA

public UnaryOperator<Integer> multiplyWith(Integer multiplier) {

    return x -> multiplier * x;
}

UnaryOperator<Integer> multiplyWithFive = multiplyWith(5);

multiplyWithFive.apply(6);
