/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 13. Zadania asynchroniczne
 *
 * Listing 13.1. Przepyw wykonywania Future<T>
 */

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FutureFlowOfExecution {

    public static void main(String... args) throws InterruptedException, ExecutionException {
        var executor = Executors.newFixedThreadPool(10);

        Callable<Integer> expensiveTask = () -> {

            System.out.println("(zadanie) start");

            TimeUnit.SECONDS.sleep(2);

            System.out.println("(zadanie) ukoczone");

            return 42;
        };


        System.out.println("(gwny) przed zatwierdzeniem zadania");

        var future = executor.submit(expensiveTask);

        System.out.println("(gwny) po zatwierdzeniu zadania");


        var theAnswer = future.get();

        System.out.println("(gwny) po blokujcym wywoaniu future.get()");

        executor.shutdown();
    }
}

