/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 10. Obsuga wyjtkw funkcyjnych
 *
 * Listing 10.5. Tradycyjny obiekt wynikw
 */

public record Result<V, E extends Throwable> (V value,
                                              E throwable,
                                              boolean success) {

    public static <V, E extends Throwable> Result<V, E> success(V value) {
        return new Result<>(value, null, true);
    }

    public static <V, E extends Throwable> Result<V, E> failure(E throwable) {
        return new Result<>(null, throwable, false);
    }
}
