/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 9. Obsuga wartoci null za pomoc typw Optional
 *
 * Listing 9.11. Pseudokod odpowiadajcy operacji reduce
 */

import java.util.functional.BinaryOperator;
import java.util.Optional;

Optional<T> pseudoReduce(BinaryOperator<T> accumulator) {
    boolean foundAny = false;
    T result = null;

    for (T element : elements]) {
        if (!foundAny) {
            foundAny = true;
            result = element;
        } else {
            result = accumulator.apply(result, element);
        }
    }

    return foundAny ? Optional.of(result)
                    : Optional.empty();
}
