/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 8. Rwnolege przetwarzanie danych za pomoc strumieni
 *
 * Listing 8.1. Sekwencyjne liczenie sw w Wojnie i pokoju
 */

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

var location = Paths.get("../other/war-and-peace.txt"); 

// WZORCE CZYSZCZENIA
var punctionaction = Pattern.compile("\\p{Punct}");
var whitespace = Pattern.compile("\\s+");
var words = Pattern.compile("\\w+");

Map<String, Integer> wordCount = null;

try {
    // ADOWANIE ZAWARTOCI
    var content = Files.readString(location);
    wordCount = 
        Stream.of(content)
              // CZYSZCZENIE ZAWARTOCI
              .map(punctionaction::matcher)
              .map(matcher -> matcher.replaceAll(""))
              // DZIELENIE NA SOWA
              .map(whitespace::split)
              .flatMap(Arrays::stream)
              .filter(word -> words.matcher(word).matches())
              // ZLICZANIE
              .map(String::toLowerCase)
              .collect(Collectors.toMap(Function.identity(),
                                        word -> 1,
                                        Integer::sum));
} catch (IOException e) {
    // ...
}

System.out.println(wordCount);
