/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 3. Interfejsy funkcyjne pakietu JDK
 */

UnaryOperator<String> unaryOp = String::toUpperCase;

Function<String, String> func = String::toUpperCase;


void acceptsUnary(UnaryOperator<String> unaryOp) {
    // ...
};

void acceptsFunction(Function<String, String> func) {
    // ...
};

// TE DWA WYWOWANIA S OK
acceptsUnary(unaryOp);
acceptsFunction(func);
acceptsFunction(unaryOp);

// TO WYWOANIE SI NIE SKOMPILUJE
acceptsUnary(func);

/*
 * COMPILER ERROR:
 * incompatible types: java.util.function.Function<java.lang.String,java.lang.String> cannot be converted to java.util.function.UnaryOperator<java.lang.String>
 * acceptsUnary(func);
 */
