/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 9. Obsuga wartoci null za pomoc typw Optional
 */

// NIE INICJUJ ZMIENNEJ Z WARTOCI NULL

// TAK NIE RB

String value = null;

if (condition) {
  value = "Warunek jest true";
} else {
  value = "Druga opcja, jeli jest false";
}

// RB TAK

String asTernary = condition ? "Warunek jest true"
                             : "Druga opcja, jeli jest false";

String asRefactored = refactoredMethod(condition);


// ================================================================

// NIE PRZEKAZUJ, NIE PRZYJMUJ, ANI NIE ZWRACAJ WARTOCI NULL

public record User(long id, String firstname, String lastname) {

  // RB TAK: dodatkowy konstruktor z domylnymi wartociami, aby unikn wartoci null
  public User(long id) {
    this(id, "n/a", "n/a");
  }

  // ...
}

public record User(long id, String firstname, String lastname) {

  // RB TAK: walidacja argumentw pod ktem wartoci null
  public User {
    Objects.requireNonNull(firstname);
    Objects.requireNonNull(lastname);
  }

  // ...
}

// ================================================================

// PODEJCIE Z UYCIEM NARZDZI

interface Example {

  @NonNull List<@Nullable String> getListOfNullableStrings(); <1>

  @Nullable List<@NonNull String> getNullableListOfNonNullStrings(); <2>

  void doWork(@Nullable String identifier); <3>
}