/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 10. Obsuga wyjtkw funkcyjnych
 *
 * Listing 10.4. Uycie Optional<String> zamiast rzucania IOException
 */

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;

Optional<String> safeReadString(Path path) {
    try {
        var content = Files.readString(path);
        return Optional.of(content);
    } catch (IOException e) {
        return Optional.empty();
    }
}