/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 2. Funkcyjna Java
 *
 * Listing 2.2. Uproszczony interfejs java.util.function.Predicate<T>
 *
 * Jest to uproszczona, niedziaajca wersja interfejsu
 * java.util.function.Predicate<T>, ktra ma zilustorwa czenie
 * pojedynczej metody abstrakcyjnej z metodami default i static.
 *
 * [Originalne rdo](https://github.com/openjdk/jdk/blob/dfacda488bfbe2e11e8d607a6d08527710286982/src/java.base/share/classes/java/util/function/Predicate.java)
 */

package java.util.function;

// Ten typ uywa tej adnotacji, cho nie jest ona bezporednio wymagana.
@FunctionalInterface
public interface Predicate<T> {

    // Pojedyncza metoda abstrakcyjna
    boolean test(T t);


    // Dostpne s trzy dodatkowe metody default

    default Predicate<T> and(Predicate<? super T> other) {
        // ...
    }

    default Predicate<T> negate() {
        // ...
    }

    default Predicate<T> or(Predicate<? super T> other) {
        // ...
    }


    // Dostpne s dwie dodatkowe metody static

    static <T> Predicate<T> isEqual(Object targetRef) {
        // ...
    }

    static <T> Predicate<T> not(Predicate<? super T> target) {
        // ...
    }
}