﻿using UnityEngine;

public class Ammo : MonoBehaviour
{
    public int damageInflicted;

    void OnTriggerEnter2D(Collider2D collision)
    {
        // Sprawdzenie, czy nastąpiła kolizja ze zderzaczem BoxCollider2D otaczającym przeciwnika.
        // Jest to konieczne, ponieważ w skrypcie Wander jest wykorzystywany zderzacz CircleCollider2D,
        // z którym kolizja nas nie interesuje.
        if (collision is BoxCollider2D)
        {
            Enemy enemy = collision.gameObject.GetComponent<Enemy>();
            StartCoroutine(enemy.DamageCharacter(damageInflicted, 0.0f));
            gameObject.SetActive(false);
        }
    }
}