using UnityEngine;
using Cinemachine;
 
public class RoundCameraPos : CinemachineExtension
{
    public float PixelsPerUnit = 32;
 

    // Metoda wywoływana przez Cinemachine gdy Confiner zakończy realizację swojego procesu

    protected override void PostPipelineStageCallback(
        CinemachineVirtualCameraBase vcam,
        CinemachineCore.Stage stage, ref CameraState state, float deltaTime)
    {
        // Sprawdzenie bieżącego etapu końcowego przetwarzania
        if (stage == CinemachineCore.Stage.Body)
        {
            // Uzyskanie końcowej pozycji kamery wirtualnej
            Vector3 finalPos = state.FinalPosition;

            // Wywołanie metody zaokrąglającej pozycję
            Vector3 newPos = new Vector3(Round(finalPos.x), Round(finalPos.y), finalPos.z);
            // Ustawienie nowej pozycji kamery wirtualnej na różnicę między  
            // poprzednią pozycją a nową zaokrągloną, wyliczoną wyżej.
            state.PositionCorrection += newPos - finalPos;
        }
    }
 
    float Round(float x)
    {
        return Mathf.Round(x * PixelsPerUnit) / PixelsPerUnit;
    }
}