﻿using System.Collections;
using UnityEngine;

public class Arc : MonoBehaviour
{
    public IEnumerator TravelArc(Vector3 destination, float duration)
    {
        var startPosition = transform.position;
        var percentComplete = 0.0f;

        while (percentComplete <= 1.0f)
        {
            // Time.deltaTime zawiera czas, jaki upłynął od wyświetlenia statniej ramki
            percentComplete += Time.deltaTime / duration;
            var currentHeight = Mathf.Sin(Mathf.PI * percentComplete);
            transform.position = Vector3.Lerp(startPosition, destination, percentComplete) + Vector3.up * currentHeight;

            yield return null;
        }

        // Jeżeli lot po łuku zakończył się, deaktywujemy obiekt
        gameObject.SetActive(false);
    }
}