package test;

import app.classes.AppTheme;
import app.module.ui.classes.GameCanvasView;
import app.module.ui.classes.HorizontalContainer;
import app.module.ui.classes.InputStringItem;
import app.module.ui.classes.SimpleTextButton;
import app.module.ui.classes.StringItem;
import app.module.ui.models.CallbackHandler;
import app.module.ui.models.UITheme;
import com.apress.framework.core.Application;
import com.apress.framework.objecttypes.Event;
import javax.microedition.midlet.*;

/**
 * @author pawelkor
 */
public class TestMidlet extends MIDlet implements CallbackHandler
{
    public boolean doCallback(Event evt)
    {
        System.out.println("ZDARZENIE " + evt.getType() + " ODEBRANE Z " +
        evt.getPayload() );
        return true;
    }

    public void startApp()
    {
        // Inicjalizuj
        Application.init(this);
        UITheme theme = new AppTheme();
        GameCanvasView view = new GameCanvasView(false,theme);

        // Dodaj widżety
        for (int i=0; i<= 10; i++)
        {
            SimpleTextButton button = new SimpleTextButton(
                                                         "PRZYCISK #" + i, this, theme);
            InputStringItem inputStrItem = new InputStringItem("Wprowadź tekst",
                         "WPROWADZANY CIĄG #" + i,"OK", "Anuluj", 140, 30, this, theme);
            view.addWidget(button);
            view.addWidget(inputStrItem);
        }

        // Utwórz poziomy kontener
        HorizontalContainer container = new HorizontalContainer(theme);
        container.setContentWidth(view.getWidth());

        // Dodaj widżety do poziomego kontenera
        for (int i=0; i<= 10; i++)
        {
            StringItem stringItem = new StringItem("#" + i + 
                    " To jest bardzo bardzo długi ciąg, który nie zmieści się w małym widoku", 77, 400, this, theme);
            container.addWidget(stringItem);
        }

        // Dodaj kontener do głównego widoku
        view.addWidget(container);

        // Poukładaj wszystko
        container.doLayout();
        view.doLayout();

        // Fokus na widok
        view.onFocus();

        // Wyświetl widok
        Application.showView(view);
    }
    
    public void pauseApp() {
    }
    
    public void destroyApp(boolean unconditional) {
    }
}
