package test;

import com.apress.framework.objecttypes.Controller;
import com.apress.framework.objecttypes.View;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

import app.module.ui.models.Widget;

public class TestView extends GameCanvas implements View
{
    Controller controller;
    TestModel model;

    public TestView(Controller controller, TestModel model)
    {
        super(true);
        this.controller = controller;
        this.model = model;
    }
    // wyświetl
    public void paint(Graphics g)
    {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, 1000, 1000);
        g.setColor(0,0,0);
        String message = model.getText() + " otrzymany z " + controller;
        System.out.println(message);
        g.drawString(message, 10, 10, Graphics.TOP | Graphics.LEFT);
    }
    // odśwież
    public boolean refresh()
    {
        repaint();
        serviceRepaints();
        return true;
    }
    // pobierz kontroler nadrzędny
    public Controller getParentController()
    {
        return controller;
    }
    // pobierz Canvas
    public GameCanvas getCanvas()
    {
        return this;
    }
    public void paintWidget(Widget w){}
}
