/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.xauth;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.util.StringUtil;
import com.twitterapime.xauth.OAuthParameters;
import com.twitterapime.xauth.Token;
import com.twitterapime.xauth.encoders.Base64Encoder;
import com.twitterapime.xauth.encoders.HMAC;
import java.util.Enumeration;
import java.util.Hashtable;

public final class XAuthSigner {
    private final String consumerKey;
    private final String consumerSecret;

    private static String getSignature(String baseString, String consumerSecret, String tokenSecret) {
        byte[] b = HMAC.getHmac(baseString, consumerSecret + '&' + tokenSecret);
        return Base64Encoder.encode(b);
    }

    public XAuthSigner(String consumerKey, String consumerSecret) {
        if (consumerKey == null || (consumerKey = consumerKey.trim()).length() == 0) {
            throw new IllegalArgumentException("Consumer key must not be empty/null");
        }
        if (consumerSecret == null || (consumerSecret = consumerSecret.trim()).length() == 0) {
            throw new IllegalArgumentException("Consumer secret must not be empty/null");
        }
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public void signForAccessToken(HttpRequest req, String username, String password) {
        req.setBodyParameter("x_auth_mode", "client_auth");
        req.setBodyParameter("x_auth_username", username);
        req.setBodyParameter("x_auth_password", password);
        OAuthParameters params = new OAuthParameters(this.consumerKey);
        String str = this.getSignatureBaseString(req, params);
        str = XAuthSigner.getSignature(str, this.consumerSecret, "");
        params.put("oauth_signature", str);
        str = params.getAuthorizationHeaderValue();
        req.setHeaderField("Authorization", str);
    }

    public void sign(HttpRequest req, Token access) {
        OAuthParameters params = new OAuthParameters(this.consumerKey);
        params.put("oauth_token", access.getToken());
        String str = this.getSignatureBaseString(req, params);
        str = XAuthSigner.getSignature(str, this.consumerSecret, access.getSecret());
        params.put("oauth_signature", str);
        str = params.getAuthorizationHeaderValue();
        req.setHeaderField("Authorization", str);
    }

    private String getSignatureBaseString(HttpRequest req, OAuthParameters params) {
        String method = StringUtil.encode(req.getMethod(), "UTF-8");
        String url = StringUtil.encode(req.getSanitizedURL(), "UTF-8");
        this.addParams(params, req.getQueryStringParams());
        this.addParams(params, req.getBodyParameters());
        String sortedParams = StringUtil.encode(params.getSortedEncodedParamsAsString(), "UTF-8");
        return method + '&' + url + '&' + sortedParams;
    }

    private void addParams(OAuthParameters params, Hashtable p) {
        Enumeration keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            params.put(key, (String)p.get(key));
        }
    }
}

