/*
 * Decompiled with CFR 0.152.
 */
package app.module.ui.classes;

import app.module.ui.classes.StringItem;
import app.module.ui.helpers.KeyHelper;
import app.module.ui.models.CallbackHandler;
import app.module.ui.models.UITheme;
import com.apress.framework.core.Application;
import com.apress.framework.objecttypes.Event;
import com.apress.framework.objecttypes.View;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class InputStringItem
extends StringItem
implements CommandListener {
    protected CallbackHandler handler;
    protected Command CMD_OK;
    protected Command CMD_CANCEL;
    protected String label;
    protected TextBox textBox;
    protected View oldView;

    public InputStringItem(String label, String initialText, String OKText, String cancelText, int maxLineWidth, int maxTextHeight, CallbackHandler handler, UITheme theme) {
        super(initialText, maxLineWidth, maxTextHeight, null, theme);
        this.label = label;
        this.handler = handler;
        this.CMD_OK = new Command(OKText, 1, 0);
        this.CMD_CANCEL = new Command(cancelText, 1, 1);
    }

    public boolean handleKeyReleased(int key) {
        if (8 == KeyHelper.getGameAction(key)) {
            this.showTextBox();
            return true;
        }
        return false;
    }

    public boolean handlePointerReleased(int x, int y) {
        super.handlePointerReleased(x, y);
        this.showTextBox();
        return true;
    }

    public void showTextBox() {
        Display d = Display.getDisplay((MIDlet)Application.getMIDlet());
        TextBox t = new TextBox(this.label, this.getText(), 1024, 0);
        t.addCommand(this.CMD_OK);
        t.addCommand(this.CMD_CANCEL);
        t.setCommandListener((CommandListener)this);
        this.oldView = this.getParentView();
        d.setCurrent((Displayable)t);
    }

    public void commandAction(Command c, Displayable d) {
        if (this.CMD_OK == c) {
            this.setText(((TextBox)d).getString());
            if (this.getParent() != null) {
                this.getParent().doLayout();
            }
            if (this.oldView != null) {
                Application.showView(this.oldView);
            }
            this.fireEvent();
        } else if (this.CMD_CANCEL == c && this.oldView != null) {
            Application.showView(this.oldView);
        }
    }

    protected void fireEvent() {
        if (this.handler != null) {
            Event event = new Event(4, 40002, this);
            this.handler.doCallback(event);
        }
    }
}

