/*
 * Decompiled with CFR 0.152.
 */
package app.module.network.classes;

import app.models.Timeline;
import app.models.Tweet;
import app.models.TweetFilter;
import com.twitterapime.rest.UserAccountManager;
import com.twitterapime.search.Query;
import com.twitterapime.search.QueryComposer;
import com.twitterapime.search.SearchDevice;

public class TimelineUserTweets
implements Timeline {
    UserAccountManager manager;
    String username;
    SearchDevice search;
    Tweet[] forwardBuffer;
    int forwardIndex = 0;
    Tweet[] backBuffer;
    int backIndex = 0;
    public static final int BUFFER_SIZE = 10;

    public TimelineUserTweets(UserAccountManager manager, TweetFilter filter) {
        com.twitterapime.search.Tweet[] result;
        this.username = filter.getUserID();
        this.manager = manager;
        this.search = SearchDevice.getInstance();
        this.forwardBuffer = new Tweet[1];
        this.backBuffer = new Tweet[1];
        Query q = QueryComposer.resultCount(1);
        q = QueryComposer.from(this.username);
        try {
            result = this.search.searchTweets(q);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (result != null && result.length > 0) {
            Tweet requestResult;
            com.twitterapime.search.Tweet tweet = result[0];
            this.forwardBuffer[0] = this.backBuffer[0] = (requestResult = new Tweet(tweet.getString("TWEET_AUTHOR_USERNAME"), tweet.getString("TWEET_CONTENT"), tweet.getString("TWEET_ID")));
        }
    }

    public Tweet goForward() {
        if (this.forwardIndex >= this.forwardBuffer.length) {
            Query q = QueryComposer.resultCount(10);
            q = QueryComposer.append(q, QueryComposer.from(this.username));
            if (this.forwardBuffer.length > 0) {
                String newestID = this.forwardBuffer[this.forwardIndex - 1].getID();
                q = QueryComposer.append(q, QueryComposer.sinceID(newestID));
            }
            try {
                com.twitterapime.search.Tweet[] results = this.search.searchTweets(q);
                if (results == null || results.length == 0) {
                    return null;
                }
                this.forwardBuffer = new Tweet[results.length];
                for (int index = 0; index < results.length; ++index) {
                    com.twitterapime.search.Tweet tweet = results[index];
                    this.forwardBuffer[results.length - index - 1] = new Tweet(tweet.getString("TWEET_AUTHOR_USERNAME"), tweet.getString("TWEET_CONTENT"), tweet.getString("TWEET_ID"));
                }
                this.forwardIndex = 0;
            }
            catch (Exception ex) {
                return null;
            }
        }
        Tweet currentTweet = this.forwardBuffer[this.forwardIndex];
        ++this.forwardIndex;
        return currentTweet;
    }

    public Tweet goBack() {
        if (this.backBuffer.length == 0 || this.backBuffer[0] == null) {
            return null;
        }
        if (this.backIndex >= this.backBuffer.length) {
            String oldestID = this.backBuffer[this.backIndex - 1].getID();
            String maxID = String.valueOf(Long.parseLong(oldestID) - 1L);
            Query q = QueryComposer.resultCount(10);
            q = QueryComposer.append(q, QueryComposer.from(this.username));
            q = QueryComposer.append(q, QueryComposer.maxID(maxID));
            try {
                com.twitterapime.search.Tweet[] results = this.search.searchTweets(q);
                if (results == null || results.length == 0) {
                    this.backBuffer = new Tweet[0];
                    return null;
                }
                this.backBuffer = new Tweet[results.length];
                for (int i = 0; i < results.length; ++i) {
                    com.twitterapime.search.Tweet tweet = results[i];
                    this.backBuffer[i] = new Tweet(tweet.getString("TWEET_AUTHOR_USERNAME"), tweet.getString("TWEET_CONTENT"), tweet.getString("TWEET_ID"));
                }
                this.backIndex = 0;
            }
            catch (Exception ex) {
                return null;
            }
        }
        Tweet currentTweet = this.backBuffer[this.backIndex];
        ++this.backIndex;
        return currentTweet;
    }
}

